/*
 * Decompiled with CFR 0.152.
 */
package webetk.xmlapi.dms.commands;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.bind.JAXBElement;
import org.apache.log4j.Logger;
import webetk.interfaces.dms.DmsMessage;
import webetk.interfaces.dms.ObjectFactory;
import webetk.interfaces.dms.TypeMarke;
import webetk.interfaces.dms.TypeTeilelisteInfoRequest;
import webetk.interfaces.dms.TypeTeilelisteInfoResponse;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.dms.XmlDmsCommand;

public class XmlDmsTeilelistenInfo
extends XmlDmsCommand {
    private String marke;
    private String[] teilenummern;
    private String[] arten;
    private String auftragsnummer;
    private int kundennummer;
    private ArrayList<TypeTeilelisteInfoResponse.Teilinformation> teilinfos = new ArrayList();
    private static Logger log = Logger.getLogger(XmlDmsTeilelistenInfo.class);

    public String getAuftragsnummer() {
        return this.auftragsnummer;
    }

    public int getKundennummer() {
        return this.kundennummer;
    }

    public void setInputParameters(String sUsername, String sFirma, String sFiliale, String sAuftragsnummer, int nKundennummer, String sMarke, Collection cTeilenummern) throws IllegalArgumentException, XmlParseException {
        this.setInputParameters(sUsername, sFirma, sFiliale, sAuftragsnummer, nKundennummer, sMarke, cTeilenummern, new ArrayList());
    }

    public void setInputParameters(String sUsername, String sFirma, String sFiliale, String sAuftragsnummer, int nKundennummer, String sMarke, Collection cTeilenummern, Collection cArten) throws IllegalArgumentException, XmlParseException {
        String[] tnrs = new String[cTeilenummern.size()];
        Iterator iterTnr = cTeilenummern.iterator();
        int index = 0;
        while (iterTnr.hasNext()) {
            tnrs[index++] = (String)iterTnr.next();
        }
        String[] arten = null;
        arten = cTeilenummern.size() > cArten.size() ? new String[cArten.size()] : new String[cTeilenummern.size()];
        Iterator iterArten = cArten.iterator();
        index = 0;
        while (iterArten.hasNext()) {
            arten[index++] = (String)iterArten.next();
        }
        this.setInputParameters(sUsername, sFirma, sFiliale, sAuftragsnummer, nKundennummer, sMarke, tnrs, arten);
    }

    public void setInputParameters(String sUsername, String sFirma, String sFiliale, String sAuftragsnummer, int nKundennummer, String sMarke, String[] aTeilenummern) throws IllegalArgumentException, XmlParseException {
        String[] aArten = new String[aTeilenummern.length];
        this.setInputParameters(sUsername, sFirma, sFiliale, sAuftragsnummer, nKundennummer, sMarke, aTeilenummern, aArten);
    }

    public void setInputParameters(String sUsername, String sFirma, String sFiliale, String sAuftragsnummer, int nKundennummer, String sMarke, String[] aTeilenummern, String[] aArten) throws IllegalArgumentException, XmlParseException {
        super.setInputParameters(sUsername, sFirma, sFiliale);
        this.marke = sMarke;
        this.auftragsnummer = sAuftragsnummer;
        this.kundennummer = nKundennummer;
        this.teilenummern = aTeilenummern;
        this.arten = aArten;
        if (this.teilenummern.length == 0) {
            log.error("Teilenummer is not defined!");
            throw new IllegalArgumentException("Teilenummer ist nicht definiert!");
        }
        if (this.marke == null || this.marke.length() == 0) {
            log.error("Marke is not defined!");
            throw new IllegalArgumentException("Marke ist nicht definiert!");
        }
        log.debug("Input seems to be in order.");
        log.debug("Constructing XML-Objects ...");
        this.constructXmlObjects();
    }

    @Override
    protected void setResultObjekt(DmsMessage ergebnisObjekt) throws XmlParseException {
        log.debug("Extracting response from XML-Objekt ...");
        if (ergebnisObjekt.getDmsTeilelistenInfo() == null) {
            log.error("XML-Objekt is not a DmsTeilelistenInfo Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsTeilelistenInfo", "Response is not of type DmsTeilelistenInfo!");
        }
        if (ergebnisObjekt.getDmsTeilelistenInfo().getDmsResponse() == null) {
            log.error("XML-Objekt is not a Response Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsTeilelistenInfo", "XML-Stream does not contain response objekt for DmsTeilelistenInfo!");
        }
        TypeTeilelisteInfoResponse resp = ergebnisObjekt.getDmsTeilelistenInfo().getDmsResponse();
        this.ergebnisCode = resp.getErgebnisCode().intValue();
        this.meldungstext = resp.getMessageText();
        this.auftragsnummer = resp.getAuftragsnummer();
        this.kundennummer = resp.getKundennummer() != null ? resp.getKundennummer().intValue() : -1;
        this.teilinfos.clear();
        this.teilinfos = new ArrayList<TypeTeilelisteInfoResponse.Teilinformation>(resp.getTeilinformation());
        log.debug("Information has been extracted.");
    }

    private TypeTeilelisteInfoResponse.Teilinformation getTI(int index) {
        return this.teilinfos.get(index);
    }

    public int getTeileCount() {
        return this.teilinfos.size();
    }

    public TypeTeilelisteInfoResponse.Teilinformation getTeilinformation(int index) {
        return this.getTI(index);
    }

    public int getErgebnisCode(int teilIndex) throws IndexOutOfBoundsException {
        TypeTeilelisteInfoResponse.Teilinformation ti = this.getTI(teilIndex);
        return ti.getErgebnisCode() != null ? ti.getErgebnisCode().intValue() : -1;
    }

    public String getTeilenummer(int teilIndex) throws IndexOutOfBoundsException {
        return this.getTI(teilIndex).getTeilenummer();
    }

    public String getTeilebezeichnung(int teilIndex) throws IndexOutOfBoundsException {
        return this.getTI(teilIndex).getBezeichnung();
    }

    public int getBedarfshinweis(int teilIndex) throws IndexOutOfBoundsException {
        TypeTeilelisteInfoResponse.Teilinformation ti = this.getTI(teilIndex);
        return ti.getBedarfshinweis() != null ? ti.getBedarfshinweis().intValue() : -1;
    }

    public Double getAUME(int teilIndex) throws IndexOutOfBoundsException {
        if (this.getTI(teilIndex).getAUME() == null) {
            return null;
        }
        return new Double(this.getTI(teilIndex).getAUME().doubleValue());
    }

    public String getLagerort(int teilIndex) throws IndexOutOfBoundsException {
        return this.getTI(teilIndex).getLagerort();
    }

    public Double getLagerbestand(int teilIndex) throws IndexOutOfBoundsException {
        if (this.getTI(teilIndex).getLagerbestand() == null) {
            return null;
        }
        return new Double(this.getTI(teilIndex).getLagerbestand().doubleValue());
    }

    public Double getMindestbestand(int teilIndex) throws IndexOutOfBoundsException {
        if (this.getTI(teilIndex).getMindestbestand() == null) {
            return null;
        }
        return new Double(this.getTI(teilIndex).getMindestbestand().doubleValue());
    }

    public double getHaendlerpreis(int teilIndex) throws IndexOutOfBoundsException {
        return this.getTI(teilIndex).getHaendlerpreis() != null ? this.getTI(teilIndex).getHaendlerpreis().doubleValue() : 0.0;
    }

    public String getRabatt(int teilIndex) throws IndexOutOfBoundsException {
        return this.getTI(teilIndex).getRabatt();
    }

    public String getKodierungsstufe(int teilIndex) throws IndexOutOfBoundsException {
        return this.getTI(teilIndex).getKodierungsstufe();
    }

    public int getDispoCode(int teilIndex) throws IndexOutOfBoundsException {
        return this.getTI(teilIndex).getDispocode() != null ? this.getTI(teilIndex).getDispocode().intValue() : 0;
    }

    public int getSuffix(int teilIndex) throws IndexOutOfBoundsException {
        return this.getTI(teilIndex).getSuffix() != null ? this.getTI(teilIndex).getSuffix().intValue() : 0;
    }

    public Double getMwst(int teilIndex) throws IndexOutOfBoundsException {
        if (this.getTI(teilIndex).getMehrwertsteuer() == null) {
            return null;
        }
        return new Double(this.getTI(teilIndex).getMehrwertsteuer().doubleValue());
    }

    public Double getSondersteuer(int teilIndex) throws IndexOutOfBoundsException {
        if (this.getTI(teilIndex).getSondersteuer() == null) {
            return null;
        }
        return new Double(this.getTI(teilIndex).getSondersteuer().doubleValue());
    }

    @Override
    protected void constructXmlObjects() throws XmlParseException {
        log.debug("Constructing XML-Objekt from input parameters for DmsTeilelistenInfo Element ...");
        DmsMessage root = new DmsMessage();
        root.setDmsTeilelistenInfo(new DmsMessage.DmsTeilelistenInfo());
        root.getDmsTeilelistenInfo().setDmsRequest(new TypeTeilelisteInfoRequest());
        TypeTeilelisteInfoRequest inputPars = root.getDmsTeilelistenInfo().getDmsRequest();
        inputPars.setUsername(this.username);
        inputPars.setFirma(this.firma);
        inputPars.setFiliale(this.filiale);
        inputPars.setMarke(TypeMarke.fromValue(this.marke));
        if (this.auftragsnummer != null) {
            inputPars.setAuftragsnummer(this.auftragsnummer);
        }
        if (this.kundennummer != -1) {
            inputPars.setKundennummer(new BigInteger(String.valueOf(this.kundennummer)));
        }
        ObjectFactory factory = new ObjectFactory();
        for (int ii = 0; ii < this.teilenummern.length; ++ii) {
            JAXBElement<String> elem = factory.createTypeTeilelisteInfoRequestTeilenummer(this.teilenummern[ii]);
            inputPars.getTeilenummerAndArt().add(elem);
            if (this.arten.length <= ii) continue;
            elem = factory.createTypeTeilelisteInfoRequestArt(this.arten[ii]);
            inputPars.getTeilenummerAndArt().add(elem);
        }
        this.XmlMessageRoot = root;
        log.debug("XML-Objekt constructed.");
    }
}

