/*
 * Decompiled with CFR 0.152.
 */
package webetk.xmlapi.dms.commands;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import webetk.interfaces.dms.DmsMessage;
import webetk.interfaces.dms.KompletteBestelllistenPosition;
import webetk.interfaces.dms.TeilErgebnis;
import webetk.interfaces.dms.TypeMarke;
import webetk.interfaces.dms.TypeVerkaufAuftragResponse;
import webetk.interfaces.dms.TypeWerkstattauftragRequest;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.dms.XmlDmsCommand;
import webetk.xmlapi.dms.commands.typen.XmlDmsBestellPositionKomplett;
import webetk.xmlapi.dms.commands.typen.XmlDmsTeilErgebnis;

public class XmlDmsWerkstattAuftrag
extends XmlDmsCommand {
    private String auftragsnummer;
    private int mitarbeiternummer;
    private String kommentar;
    private boolean greiferscheinIndikator;
    private ArrayList<XmlDmsTeilErgebnis> ergebnisse = new ArrayList();

    public String getAuftragsnummer() {
        return this.auftragsnummer;
    }

    public void setInputParameters(String sUsername, String sFirma, String sFiliale, int nMitarbeiternummer, String sKommentar, String sAuftragsnummer, boolean bGreiferschein) throws IllegalArgumentException, XmlParseException {
        super.setInputParameters(sUsername, sFirma, sFiliale);
        this.mitarbeiternummer = nMitarbeiternummer;
        this.kommentar = sKommentar;
        this.auftragsnummer = sAuftragsnummer;
        this.greiferscheinIndikator = bGreiferschein;
        Logger.getLogger(XmlDmsWerkstattAuftrag.class).debug("Constructing XML-Objects ...");
        this.constructXmlObjects();
    }

    public void addPosition(XmlDmsBestellPositionKomplett position) {
        TypeWerkstattauftragRequest inputPars = this.XmlMessageRoot.getDmsWerkstattauftrag().getDmsRequest();
        KompletteBestelllistenPosition pos = new KompletteBestelllistenPosition();
        pos.setTeilenummer(position.getTeilenummer());
        pos.setMarke(TypeMarke.fromValue(position.getMarke()));
        pos.setBezeichnung(position.getBezeichnung());
        pos.setMenge(new BigDecimal(position.getMenge()).setScale(2, 4));
        pos.setNettopreis(new BigDecimal(position.getNettopreis()).setScale(2, 4));
        pos.setPreisPreisdatei(new BigDecimal(position.getPreisdateipreis()).setScale(2, 4));
        pos.setRabatt(position.getRabatt());
        pos.setKodierungsstufe(position.getKodierungsstufe());
        pos.setSuffix(new BigInteger(String.valueOf(position.getSuffix())));
        if (position.getSplitKennzeichen() != -1) {
            pos.setSplitKennzeichen(new BigInteger(String.valueOf(position.getSplitKennzeichen())));
        }
        pos.setProduktklasse(position.getProduktklasse());
        pos.setTeileart(position.getTeileart());
        pos.setSNP(new BigDecimal(position.getSNP()).setScale(2, 4));
        pos.setRT(position.getRT());
        pos.setKommentar(position.getKommentar());
        inputPars.getPosition().add(pos);
    }

    public void clearPositionen() {
        this.XmlMessageRoot.getDmsBarverkauf().getDmsRequest().getPosition().clear();
    }

    public int getErgebnisCount() {
        return this.ergebnisse.size();
    }

    public String getTeilenummer(int index) {
        return this.ergebnisse.get(index).getTeilenummer();
    }

    public int getErgebnisCode(int index) {
        return this.ergebnisse.get(index).getErgebniscode();
    }

    @Override
    protected void setResultObjekt(DmsMessage ergebnisObjekt) throws XmlParseException {
        Logger.getLogger(XmlDmsWerkstattAuftrag.class).debug("Extracting response from XML-Objekt ...");
        if (ergebnisObjekt.getDmsWerkstattauftrag() == null) {
            Logger.getLogger(XmlDmsWerkstattAuftrag.class).error("XML-Objekt is not a DmsWerkstattAuftrag Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsWerkstattAuftrag", "Response is not of type DmsWerkstattAuftrag!");
        }
        if (ergebnisObjekt.getDmsWerkstattauftrag().getDmsResponse() == null) {
            Logger.getLogger(XmlDmsWerkstattAuftrag.class).error("XML-Objekt is not a Response Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsWerkstattAuftrag", "XML-Stream does not contain response objekt for DmsWerkstattAuftrag!");
        }
        TypeVerkaufAuftragResponse resp = ergebnisObjekt.getDmsWerkstattauftrag().getDmsResponse();
        this.ergebnisCode = resp.getErgebnisCode().intValue();
        this.meldungstext = resp.getMessageText();
        this.auftragsnummer = resp.getAuftragsnummer();
        for (TeilErgebnis te : resp.getTeilErgebnis()) {
            int nECode = te.getErgebnisCode() != null ? te.getErgebnisCode().intValue() : -1;
            XmlDmsTeilErgebnis ergebnis = new XmlDmsTeilErgebnis(te.getTeilenummer(), nECode);
            this.ergebnisse.add(ergebnis);
        }
        Logger.getLogger(XmlDmsWerkstattAuftrag.class).debug("Information has been extracted.");
    }

    @Override
    protected void constructXmlObjects() throws XmlParseException {
        Logger.getLogger(XmlDmsWerkstattAuftrag.class).debug("Constructing XML-Objekt from input parameters for DmsWerkstattAuftrag Element ...");
        DmsMessage root = new DmsMessage();
        root.setDmsWerkstattauftrag(new DmsMessage.DmsWerkstattauftrag());
        root.getDmsWerkstattauftrag().setDmsRequest(new TypeWerkstattauftragRequest());
        TypeWerkstattauftragRequest inputPars = root.getDmsWerkstattauftrag().getDmsRequest();
        inputPars.setUsername(this.username);
        inputPars.setFirma(this.firma);
        inputPars.setFiliale(this.filiale);
        inputPars.setMitarbeiterNr(new BigInteger(String.valueOf(this.mitarbeiternummer)));
        inputPars.setKommentar(this.kommentar);
        if (this.auftragsnummer != null) {
            inputPars.setAuftragsnummer(this.auftragsnummer);
        }
        inputPars.setGreiferschein(this.greiferscheinIndikator);
        inputPars.getPosition().clear();
        this.XmlMessageRoot = root;
        Logger.getLogger(XmlDmsWerkstattAuftrag.class).debug("XML-Objekt constructed.");
    }
}

