/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.adapter.ccmessages;

import com.bmw.gki.adapter.ccmessages.PAKRawReader;
import com.bmw.gki.klib.api.exception.KSDDataException;
import com.bmw.gki.logging.GKILogManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.logging.Log;

public class CCDataEReihe {
    private static Log log = GKILogManager.getInstance().getLogger(CCDataEReihe.class);
    private Hashtable<String, String> mEReiheToId;
    private RandomAccessFile mRaf;
    private String ccPath;

    public CCDataEReihe(String ccPath) {
        this.ccPath = ccPath;
    }

    private void readEReiheData(Locale locale) throws FileNotFoundException, KSDDataException {
        Properties props = new Properties();
        String fileName = this.ccPath + "/MAPPING.PROPERTIES";
        this.mEReiheToId = new Hashtable();
        FileInputStream fis = null;
        try {
            this.mRaf = new RandomAccessFile(fileName, "r");
            PAKRawReader pakReader = new PAKRawReader(fileName);
            boolean isCompressed = pakReader.readPackFileCode(this.mRaf);
            if (isCompressed) {
                pakReader.readHeader(this.mRaf);
                byte[] buffer = pakReader.readPackFile(this.mRaf);
                this.mEReiheToId = pakReader.readBufferAsHashTable(buffer);
            } else {
                fis = new FileInputStream(fileName);
                props.load(fis);
                Enumeration<?> ereiheKeys = props.propertyNames();
                while (ereiheKeys.hasMoreElements()) {
                    String ereihe = (String)ereiheKeys.nextElement();
                    String textpaketId = props.getProperty(ereihe);
                    this.mEReiheToId.put(ereihe, textpaketId);
                }
            }
        }
        catch (IOException e) {
            throw new FileNotFoundException(fileName);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
            if (this.mRaf != null) {
                try {
                    this.mRaf.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String getTextpaketId(String ereihe, Locale locale) throws FileNotFoundException, KSDDataException {
        String sKey = ereihe;
        String sRet = "";
        log.debug((Object)("mEReihe IDs: " + this.mEReiheToId));
        if (this.mEReiheToId == null) {
            this.readEReiheData(locale);
        }
        if (!(this.mEReiheToId.containsKey(sKey) || this.mEReiheToId.containsKey(sKey = sKey.substring(0, 2) + "?") || this.mEReiheToId.containsKey(sKey = sKey.substring(0, 1) + "??"))) {
            sKey = "";
        }
        if (sKey != "") {
            sRet = this.mEReiheToId.get(sKey);
        }
        return sRet;
    }
}

