/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.adapter.ccmessages;

import com.bmw.gki.adapter.ccmessages.CCDataEReihe;
import com.bmw.gki.adapter.ccmessages.CCDataReader;
import com.bmw.gki.klib.api.exception.KSDDataException;
import com.bmw.gki.klib.data.ksd.cc.CCMessage;
import com.bmw.gki.klib.data.ksd.cc.CheckControlRetrievalException;
import com.bmw.gki.klib.util.StringHelper;
import com.bmw.gki.logging.GKILogManager;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class CCDataLogic {
    private static Log log = GKILogManager.getInstance().getLogger(CCDataLogic.class);
    private static final int CC_ID_LEN = 5;
    private static final int ENGINEERINGSERIES_LEN = 4;
    private static CCDataEReihe ccDataEReihe;
    private static CCDataReader ccDataReader;
    private static int lenSet;
    private static CCDataLogic instance;
    private static boolean CLEAN_DATA;

    private CCDataLogic() {
    }

    public void setCCPath(String ccDataPath) {
        ccDataEReihe = new CCDataEReihe(ccDataPath);
        ccDataReader = new CCDataReader(ccDataPath);
    }

    public static Map<String, CCMessage> retrieveCCData(String engineeringSeries, Locale locale, Set<?> ccIds) throws FileNotFoundException, CheckControlRetrievalException, KSDDataException {
        HashMap<String, CCMessage> result = new HashMap<String, CCMessage>();
        lenSet = ccIds == null ? 0 : ccIds.size();
        log.info((Object)("Engineering Series: " + engineeringSeries + " Params (" + lenSet + ")"));
        if (lenSet == 0) {
            return result;
        }
        String sEReihe = engineeringSeries;
        if (sEReihe.length() == 3) {
            sEReihe = sEReihe + " ";
        }
        if (!CCDataLogic.checkEngineeringSeries(sEReihe)) {
            log.info((Object)("Empty or not supported ESeries:" + engineeringSeries));
            return result;
        }
        try {
            String sTextpaketId = ccDataEReihe.getTextpaketId(engineeringSeries, locale);
            if (sTextpaketId != null && sTextpaketId.length() > 0) {
                Iterator<?> itCCId = ccIds.iterator();
                while (itCCId.hasNext()) {
                    String ccId = itCCId.next().toString();
                    String ccIdKey = "00000".substring(0, 5 - ccId.length()) + ccId;
                    if (CCDataLogic.checkCCId(ccId, 5)) {
                        String sMessageText = "";
                        String sActionText = "";
                        String sCCData = ccDataReader.getCCData(sTextpaketId + ccId, locale);
                        if (sCCData != null && sCCData.length() > 0) {
                            int iIdx = sCCData.indexOf(";");
                            if (iIdx > 0) {
                                sMessageText = sCCData.substring(0, iIdx);
                                sActionText = sCCData.substring(iIdx + 1);
                            } else {
                                sMessageText = sCCData;
                            }
                            if (CLEAN_DATA) {
                                sMessageText = StringHelper.removeChar((String)sMessageText, (String)"\\");
                                sActionText = StringHelper.removeChar((String)sActionText, (String)"\\");
                            }
                            CCMessage ccMessage = new CCMessage(ccId, sMessageText, sActionText);
                            result.put(ccIdKey, ccMessage);
                            continue;
                        }
                        result.put(ccIdKey, null);
                        continue;
                    }
                    result.put(ccIdKey, null);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        return result;
    }

    public static boolean hasLen(String field, int len) {
        return field != null && field.length() == len;
    }

    public static boolean checkCCId(String ccId, int ccIdLen) {
        if (!CCDataLogic.hasLen(ccId, ccIdLen)) {
            return false;
        }
        try {
            int i = Integer.parseInt(ccId);
            return i >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean checkEngineeringSeries(String engSeries) {
        return CCDataLogic.hasLen(engSeries, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CCDataLogic getInstance() {
        if (instance != null) return instance;
        Class<CCDataLogic> clazz = CCDataLogic.class;
        synchronized (CCDataLogic.class) {
            instance = new CCDataLogic();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void reset() {
        instance = null;
        ccDataEReihe = null;
        ccDataReader = null;
    }

    static {
        lenSet = 0;
        CLEAN_DATA = true;
    }
}

