/*
 * Decompiled with CFR 0.152.
 */
package de.esg.tools.win32.registry;

public class WindowsRegistry {
    private static final int HKEY_CLASSES_ROOT = 1;
    private static final int HKEY_CURRENT_CONFIG = 2;
    private static final int HKEY_CURRENT_USER = 3;
    private static final int HKEY_LOCAL_MACHINE = 4;
    private static final int HKEY_USERS = 5;

    public static String getValueAsString(String keyName, String valueName) {
        if (WindowsRegistry.isMSWindows()) {
            if (valueName == null) {
                valueName = "";
            }
            if (keyName.startsWith("HKEY_CLASSES_ROOT")) {
                return WindowsRegistry.getValueAsStringImpl(1, keyName.substring("HKEY_CLASSES_ROOT".length() + 1), valueName);
            }
            if (keyName.startsWith("HKEY_CURRENT_CONFIG")) {
                return WindowsRegistry.getValueAsStringImpl(2, keyName.substring("HKEY_CURRENT_CONFIG".length() + 1), valueName);
            }
            if (keyName.startsWith("HKEY_CURRENT_USER")) {
                return WindowsRegistry.getValueAsStringImpl(3, keyName.substring("HKEY_CURRENT_USER".length() + 1), valueName);
            }
            if (keyName.startsWith("HKEY_LOCAL_MACHINE")) {
                return WindowsRegistry.getValueAsStringImpl(4, keyName.substring("HKEY_LOCAL_MACHINE".length() + 1), valueName);
            }
            if (keyName.startsWith("HKEY_USERS")) {
                return WindowsRegistry.getValueAsStringImpl(5, keyName.substring("HKEY_USERS".length() + 1), valueName);
            }
            throw new IllegalArgumentException("keyName must start with HKEY_CLASSES_ROOT, HKEY_CURRENT_CONFIG, HKEY_CURRENT_USER, HKEY_LOCAL_MACHINE or HKEY_USERS");
        }
        return null;
    }

    public static byte[] getValueAsByteArray(String keyName, String valueName) {
        if (WindowsRegistry.isMSWindows()) {
            if (valueName == null) {
                valueName = "";
            }
            if (keyName.startsWith("HKEY_CLASSES_ROOT")) {
                return WindowsRegistry.getValueAsByteArrayImpl(1, keyName.substring("HKEY_CLASSES_ROOT".length() + 1), valueName);
            }
            if (keyName.startsWith("HKEY_CURRENT_CONFIG")) {
                return WindowsRegistry.getValueAsByteArrayImpl(2, keyName.substring("HKEY_CURRENT_CONFIG".length() + 1), valueName);
            }
            if (keyName.startsWith("HKEY_CURRENT_USER")) {
                return WindowsRegistry.getValueAsByteArrayImpl(3, keyName.substring("HKEY_CURRENT_USER".length() + 1), valueName);
            }
            if (keyName.startsWith("HKEY_LOCAL_MACHINE")) {
                return WindowsRegistry.getValueAsByteArrayImpl(4, keyName.substring("HKEY_LOCAL_MACHINE".length() + 1), valueName);
            }
            if (keyName.startsWith("HKEY_USERS")) {
                return WindowsRegistry.getValueAsByteArrayImpl(5, keyName.substring("HKEY_USERS".length() + 1), valueName);
            }
            throw new IllegalArgumentException("keyName must start with HKEY_CLASSES_ROOT, HKEY_CURRENT_CONFIG, HKEY_CURRENT_USER, HKEY_LOCAL_MACHINE or HKEY_USERS");
        }
        return null;
    }

    public static String[] getValues(String keyName) {
        if (WindowsRegistry.isMSWindows()) {
            if (keyName.startsWith("HKEY_CLASSES_ROOT")) {
                return WindowsRegistry.getValuesImpl(1, keyName.substring("HKEY_CLASSES_ROOT".length() + 1));
            }
            if (keyName.startsWith("HKEY_CURRENT_CONFIG")) {
                return WindowsRegistry.getValuesImpl(2, keyName.substring("HKEY_CURRENT_CONFIG".length() + 1));
            }
            if (keyName.startsWith("HKEY_CURRENT_USER")) {
                return WindowsRegistry.getValuesImpl(3, keyName.substring("HKEY_CURRENT_USER".length() + 1));
            }
            if (keyName.startsWith("HKEY_LOCAL_MACHINE")) {
                return WindowsRegistry.getValuesImpl(4, keyName.substring("HKEY_LOCAL_MACHINE".length() + 1));
            }
            if (keyName.startsWith("HKEY_USERS")) {
                return WindowsRegistry.getValuesImpl(5, keyName.substring("HKEY_USERS".length() + 1));
            }
            throw new IllegalArgumentException("keyName must start with HKEY_CLASSES_ROOT, HKEY_CURRENT_CONFIG, HKEY_CURRENT_USER, HKEY_LOCAL_MACHINE or HKEY_USERS");
        }
        return null;
    }

    public static void setValueAsString(String keyName, String valueName, String value) {
        if (WindowsRegistry.isMSWindows()) {
            if (keyName.startsWith("HKEY_CLASSES_ROOT")) {
                WindowsRegistry.setValueAsStringImpl(1, keyName.substring("HKEY_CLASSES_ROOT".length() + 1), valueName, value);
            } else if (keyName.startsWith("HKEY_CURRENT_CONFIG")) {
                WindowsRegistry.setValueAsStringImpl(2, keyName.substring("HKEY_CURRENT_CONFIG".length() + 1), valueName, value);
            } else if (keyName.startsWith("HKEY_CURRENT_USER")) {
                WindowsRegistry.setValueAsStringImpl(3, keyName.substring("HKEY_CURRENT_USER".length() + 1), valueName, value);
            } else if (keyName.startsWith("HKEY_LOCAL_MACHINE")) {
                WindowsRegistry.setValueAsStringImpl(4, keyName.substring("HKEY_LOCAL_MACHINE".length() + 1), valueName, value);
            } else if (keyName.startsWith("HKEY_USERS")) {
                WindowsRegistry.setValueAsStringImpl(5, keyName.substring("HKEY_USERS".length() + 1), valueName, value);
            } else {
                throw new IllegalArgumentException("keyName must start with HKEY_CLASSES_ROOT, HKEY_CURRENT_CONFIG, HKEY_CURRENT_USER, HKEY_LOCAL_MACHINE or HKEY_USERS");
            }
        }
    }

    public static boolean isMSWindows() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return false;
        }
        return (os = os.toUpperCase()).indexOf("WIN") != -1;
    }

    private static native String setValueAsStringImpl(int var0, String var1, String var2, String var3);

    private static native String getValueAsStringImpl(int var0, String var1, String var2);

    private static native byte[] getValueAsByteArrayImpl(int var0, String var1, String var2);

    private static native String[] getValuesImpl(int var0, String var1);

    static {
        try {
            System.loadLibrary("WindowsRegistryDLL");
        }
        catch (UnsatisfiedLinkError ex) {
            try {
                System.loadLibrary("WindowsRegistryDLL2");
            }
            catch (UnsatisfiedLinkError ex2) {
                System.out.println("UnsatisfiedLinkError " + ex2.getMessage());
            }
        }
    }
}

