/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient;

import de.esg.tools.win32.registry.WindowsRegistry;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.JOptionPane;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.startup.Tomcat;
import webetk.javaclient.GlobalObjects;

public class Starter {
    private static boolean bScore = false;
    private static boolean bIpac = false;
    private static String sPort = null;
    private static String tmpDir = null;
    private static String propFileName = null;
    private static String debugETK = null;
    private static String sEtkPort = null;
    private static boolean bStandalone = false;

    public static void main(String[] args) throws Exception {
        try {
            System.setProperty("debugETK", "false");
            for (String arg : args) {
                if (arg == null) continue;
                System.out.println("Aufrufargument: " + arg);
                if (arg.indexOf("port=") > -1) {
                    bScore = true;
                    sPort = arg.substring(5);
                }
                if (arg.indexOf("app=zub") > -1) {
                    System.out.println("is zub");
                    bIpac = true;
                }
                if (arg.indexOf("tmp=") > -1 && (tmpDir = arg.substring(4)) != null) {
                    System.out.println("tmp= " + tmpDir);
                }
                if (arg.indexOf("prop=") > -1 && (propFileName = arg.substring(5)) != null) {
                    System.out.println("prop(Starter)= " + propFileName);
                }
                if (arg.indexOf("debugETK=") <= -1 || (debugETK = arg.substring(9)) == null) continue;
                System.out.println("debugETK(Starter)= " + debugETK);
                if (!debugETK.equals("true")) continue;
                System.setProperty("debugETK", debugETK);
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (propFileName != null) {
                Class<?> initLoggingClass = cl.loadClass("de.esg.commonclient.InitLogging");
                Method initLoggingMethod = initLoggingClass.getMethod("initLogging", String.class);
                initLoggingMethod.invoke(null, propFileName);
            }
            if (!bScore) {
                Class<?> cGlobalPropertyReader = cl.loadClass("webetk.javaclient.GlobalPropertyReader");
                Object o = cGlobalPropertyReader.newInstance();
                Method isStandalone = cGlobalPropertyReader.getMethod("isStandalone", null);
                Method setPropFileName = cGlobalPropertyReader.getMethod("setPropFileName", String.class);
                Method getPortName = cGlobalPropertyReader.getMethod("getPortName", new Class[0]);
                bStandalone = (Boolean)isStandalone.invoke(o, (Object[])null);
                Starter.showDebugMessage("bStandalone :" + bStandalone);
                if (bStandalone && propFileName == null) {
                    propFileName = System.getProperty("user.dir") + File.separator + "javaclient.properties";
                    System.out.println("using user.dir for logging: " + propFileName);
                }
                Starter.showDebugMessage("propFileName :" + propFileName);
                if (propFileName != null) {
                    setPropFileName.invoke(o, propFileName);
                }
                if (bStandalone) {
                    sEtkPort = (String)getPortName.invoke(o, new Object[0]);
                }
                Starter.showDebugMessage("if (!bScore) - end ");
            } else {
                sEtkPort = GlobalObjects.getInstance().getEtkclientwsPortFrom();
            }
            if (bStandalone || bScore) {
                Starter.showDebugMessage("vor startServerNew()");
                sEtkPort = Starter.startServerThread(sEtkPort, bScore, tmpDir);
                Starter.showDebugMessage("nach startServerNew()");
            }
            if (!bScore) {
                String tmpDirName = WindowsRegistry.getValueAsString("HKEY_LOCAL_MACHINE\\SOFTWARE\\BMWgroup\\webetk", "tmpdir");
                if (tmpDirName != null && tmpDirName.trim().length() > 0) {
                    System.out.println("set tmp dir: " + tmpDirName);
                    System.setProperty("java.io.tmpdir", tmpDirName);
                }
                Starter.showDebugMessage("nach WindowsRegistry...");
                System.out.println("Invoking main()");
                Class<?> cMainViewController = null;
                if (bIpac) {
                    Starter.showDebugMessage("vor IPAC Aufruf ...");
                    cMainViewController = cl.loadClass("de.esg.zub.common.MainController");
                } else {
                    Starter.showDebugMessage("vor ETK Aufruf ...");
                    cMainViewController = cl.loadClass("webetk.javaclient.framework.MainViewController");
                }
                Starter.showDebugMessage("vor get main method ...");
                Method m = cMainViewController.getMethod("main", String[].class);
                if (m == null) {
                    Starter.showDebugMessage("nach get main method ... m = null ");
                    System.out.println("main methode nicht gefunden");
                }
                try {
                    String[] argsm = new String[args.length + 1];
                    for (int ii = 0; ii < args.length; ++ii) {
                        if (args[ii] == null || args[ii].indexOf("threadid=") <= -1 && args[ii].indexOf("userid=") <= -1 && args[ii].indexOf("prop=") <= -1) continue;
                        argsm[ii] = args[ii];
                    }
                    if (sEtkPort != null) {
                        argsm[args.length] = "serverport=" + sEtkPort;
                    }
                    Starter.showDebugMessage("vor Aufruf ain method ...");
                    m.invoke(null, new Object[]{argsm});
                }
                catch (IllegalArgumentException e) {
                    Starter.showDebugMessage("IllegalArgumentException ..." + e.getMessage());
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    Starter.showDebugMessage("IllegalAccessException ..." + e.getMessage());
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    Starter.showDebugMessage("InvocationTargetException ..." + e.getMessage());
                    Throwable t = e.getTargetException();
                    t.printStackTrace();
                }
            } else {
                System.out.println("sEtkPort" + sEtkPort);
                System.out.println("sPort" + sPort);
                Starter.sendPortToApas(sPort, sEtkPort);
            }
            Starter.showDebugMessage("vor new Waitthread() ...");
            Waitthread waitThread = new Waitthread();
            Starter.showDebugMessage("vor new Waitthread() start() ...");
            waitThread.start();
            Starter.showDebugMessage("nach new Waitthread() start() ...");
        }
        catch (Throwable e) {
            StackTraceElement[] elem;
            String blub = e.getMessage() + "\n";
            blub = blub + "\n";
            for (StackTraceElement stackTraceElement : elem = e.getStackTrace()) {
                blub = blub + "\n" + stackTraceElement.getClassName() + " " + stackTraceElement.getLineNumber();
                blub = blub + "\n" + stackTraceElement.toString();
            }
            JOptionPane.showConfirmDialog(null, "System.exit: " + blub, "Einverst\u00e4ndnis", 0);
        }
    }

    private static void showDebugMessage(String string) {
        if ("true".equals(System.getProperty("debugETK"))) {
            JOptionPane.showConfirmDialog(null, string, "dubug Starter", 0);
        }
    }

    public static void sendPortToApas(String sApasPort, String sEtkPort) {
        try {
            Socket socket = new Socket("127.0.0.1", Integer.parseInt(sApasPort));
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            System.out.println("Sending ETK-Port to Score on " + sApasPort);
            if (GlobalObjects.getInstance().getEtkclientwsPortDebug()) {
                int nPort = Integer.parseInt(sEtkPort);
                sEtkPort = String.valueOf(nPort + 1);
            }
            out.println(sEtkPort);
            out.close();
            socket.close();
            System.out.println("Send ETK Port " + sEtkPort + " to Score.");
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            ex.printStackTrace();
        }
    }

    public static String startServerThread(String sEtkPort, boolean bScore, String tmpDirArg) {
        ServerSocket server;
        File tmpDir;
        File f = new File("tomcat");
        if (!f.exists()) {
            JOptionPane.showMessageDialog(null, "Verzeichnis tomcat muss existieren!");
            throw new RuntimeException("Verzeichnis tomcat muss existieren!");
        }
        System.setProperty("catalina.base", f.getAbsolutePath());
        System.setProperty("catalina.home", f.getAbsolutePath());
        String tmpDirName = tmpDirArg;
        if (tmpDirName == null || tmpDirName.trim().length() < 1) {
            tmpDirName = WindowsRegistry.getValueAsString("HKEY_LOCAL_MACHINE\\SOFTWARE\\BMWgroup\\webetk", "tmpdir");
        }
        if (tmpDirName == null || tmpDirName.trim().length() < 1) {
            tmpDirName = f.getAbsolutePath() + "\\temp";
        }
        if (!(tmpDir = new File(tmpDirName)).canWrite()) {
            System.err.println("Server will not start because tmpDir is not writable!");
        }
        System.setProperty("java.io.tmpdir", tmpDirName);
        System.out.println("Tomcat temp : " + tmpDirName);
        System.setProperty("java.endorsed.dirs", f.getAbsolutePath() + "\\endorsed");
        System.out.println("Java Version : " + System.getProperty("java.vm.version"));
        int nPort = Integer.valueOf(sEtkPort);
        try {
            boolean bIsAvailable = false;
            while (!bIsAvailable) {
                try {
                    server = new ServerSocket();
                    server.bind(new InetSocketAddress(nPort));
                    server.close();
                    bIsAvailable = true;
                    System.out.println("Using Port: " + nPort);
                }
                catch (IOException ioEx) {
                    System.out.println("Port in use: " + nPort);
                    ++nPort;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(null, "Fehler beim Start des Servers: " + e.getLocalizedMessage());
        }
        System.out.println("Temp-Dir: " + System.getProperty("java.io.tmpdir"));
        if ("true".equals(System.getProperty("debugETK"))) {
            URLClassLoader urlCl = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            URL[] aUrls = urlCl.getURLs();
            StringBuffer sPath = new StringBuffer("class loader #1");
            for (URL url : aUrls) {
                sPath.append(url.getFile() + ";\n");
            }
            Starter.showDebugMessage(sPath.toString());
        }
        if (nPort == 0) {
            nPort = 8080;
        }
        Tomcat tomcat = new Tomcat();
        tomcat.setPort(nPort);
        tomcat.setBaseDir(f.getAbsolutePath());
        server = (StandardServer)tomcat.getServer();
        AprLifecycleListener listener = new AprLifecycleListener();
        server.addLifecycleListener((LifecycleListener)listener);
        Starter.showDebugMessage("startServerNew: nach boot.setCatalinaBase(f.getAbsolutePath()): " + f.getAbsolutePath());
        try {
            if (bScore) {
                Starter.showDebugMessage("starting SCORE Port: " + nPort);
                tomcat.addWebapp("/axis", "axis");
            } else {
                Starter.showDebugMessage("starting javaserver und Zubwbt Port: " + nPort);
                tomcat.addWebapp("/javaserver", "javaserver");
                tomcat.addWebapp("/Zubwbt", "Zubwbt");
            }
        }
        catch (Exception e) {
            Starter.showDebugMessage(e.getMessage());
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(null, "Could not register application war: " + e.getLocalizedMessage());
        }
        TomcatThread tomcatThread = new TomcatThread(tomcat);
        try {
            tomcatThread.startTomcat();
            while (!tomcatThread.isStarted()) {
                System.out.println("Server State:" + tomcat.getServer().getStateName() + " waiting ...");
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            Starter.showDebugMessage(e.getMessage());
            e.printStackTrace(System.err);
            JOptionPane.showMessageDialog(null, "Could not start Tomcat: " + e.getLocalizedMessage());
        }
        return String.valueOf(nPort);
    }

    private static class TomcatThread
    extends Thread {
        private final Tomcat tomcat;

        public TomcatThread(Tomcat tomcat) {
            this.tomcat = tomcat;
        }

        public void startTomcat() {
            this.start();
        }

        @Override
        public void run() {
            try {
                System.out.println("Tomcat starting " + this.tomcat.getServer().getAddress() + " State: " + this.tomcat.getServer().getStateName());
                this.tomcat.start();
                System.out.println("Tomcat await - TomcatThread runnning " + this.tomcat.getServer().getAddress() + " State: " + this.tomcat.getServer().getStateName());
                this.tomcat.getServer().await();
            }
            catch (Exception e) {
                Starter.showDebugMessage(e.getMessage());
                e.printStackTrace(System.err);
                System.out.println("FATAL: " + e.getMessage());
            }
        }

        public boolean isStarted() {
            return this.tomcat.getServer().getState().equals((Object)LifecycleState.STARTED);
        }

        public void stopTomcat() {
            try {
                System.out.println("Tomcat stopping " + this.tomcat.getServer().getAddress() + " State: " + this.tomcat.getServer().getStateName());
                this.tomcat.stop();
                System.out.println("Tomcat stopped " + this.tomcat.getServer().getAddress() + " State: " + this.tomcat.getServer().getStateName());
            }
            catch (Exception e) {
                Starter.showDebugMessage(e.getMessage());
                e.printStackTrace(System.err);
                System.out.println("FATAL: " + e.getMessage());
            }
        }
    }

    private static class Waitthread
    extends Thread {
        private Waitthread() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Waitthread.sleep(1L);
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }
}

