<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl = "http://www.w3.org/1999/XSL/Transform" version = "1.0" 
	xmlns:old="http://www.bmw.com/score" exclude-result-prefixes="old">

	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
  		<xsl:apply-templates/>
    </xsl:template>
	
	<xsl:template match="@version"><xsl:attribute name="version">05.00.00</xsl:attribute></xsl:template>
	
	
	<xsl:template match = "*[local-name()='servicePackage']">
		<xsl:element name="servicePackage" namespace="http://www.bmw.com/gki">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="*[local-name()='contract']"/>
			<xsl:apply-templates select="*[local-name()='contractVolume']"/>
			<xsl:apply-templates select="*[local-name()='origin']"/>
			<xsl:element name="cashUpStartDate" namespace="http://www.bmw.com/gki"><xsl:value-of select="*[local-name()='startDate']"/></xsl:element>
			<xsl:element name="startKm" namespace="http://www.bmw.com/gki"><xsl:attribute name="units">km</xsl:attribute>0</xsl:element>
			<xsl:element name="endKm" namespace="http://www.bmw.com/gki"><xsl:attribute name="units">km</xsl:attribute><xsl:value-of select="*[local-name()='distance']"/></xsl:element>
			<xsl:apply-templates select="*[local-name()='startDate']"/>
			<xsl:apply-templates select="*[local-name()='endDate']"/>
			<xsl:apply-templates select="*[local-name()='duration']"/>
			<xsl:apply-templates select="*[local-name()='distance']"/>
			<xsl:apply-templates select="*[local-name()='description']"/>
		</xsl:element>
	</xsl:template>
	
	
	<xsl:template match = "*">
		<xsl:copy>
			<xsl:apply-templates select = "node()|@*" />
		</xsl:copy>
	</xsl:template>
	<xsl:template match="@*">
		<xsl:copy/>
	</xsl:template>
	
	<!-- replace namespace of elements in old namespace -->
	<xsl:template match="old:*">
		<xsl:element name="{local-name()}" namespace="http://www.bmw.com/gki">
			<xsl:apply-templates select="@* | node()"/>
		</xsl:element>
	</xsl:template>
	
</xsl:stylesheet>