/*
 * Decompiled with CFR 0.152.
 */
package mods.awger.smallboat;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import java.util.List;
import java.util.UUID;
import mods.awger.logger;
import mods.awger.smallboat.EntityBoatChest;
import mods.awger.smallboat.EntitySmallBoat;
import mods.awger.smallboat.SmallBoat;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class EntityBoatPart
extends Entity
implements IEntityAdditionalSpawnData {
    public EntitySmallBoat Parent;
    private UUID ParentPersistentID;
    public String Name;
    public int ModelIndex;
    public float posOfsX;
    public float posOfsY;
    public float posOfsZ;
    public float riderOfsX;
    public float riderOfsY;
    public float riderOfsZ;
    public float renderOfsX;
    public float renderOfsY;
    public float renderOfsZ;
    public float renderRotX;
    public float renderRotY;
    public float renderRotZ;
    private int trackRider = 1;
    private int parentId = 0;
    int savedId;
    public boolean canInteract = true;
    public boolean hasSeat;
    public boolean hasChest;
    public boolean isDeck = false;
    private byte BoundingFlags = 0;
    private int SuicideCounter = 500;
    private AxisAlignedBB deckBoundingBox;

    public EntityBoatPart(World par1World) {
        super(par1World);
        logger.fine(SmallBoat.LogLevel, "%s: instantiating generic EntityBoatPart(%d)", par1World.field_72995_K ? "client" : "server", this.field_70157_k);
        this.savedId = this.field_70157_k;
        this.field_70156_m = true;
        this.Name = "zombie";
        this.ModelIndex = -1;
        this.func_70105_a(0.95f, 0.95f);
        this.posOfsX = 0.0f;
        this.posOfsY = 0.0f;
        this.posOfsZ = 0.0f;
        this.riderOfsX = 0.0f;
        this.riderOfsY = 0.0f;
        this.riderOfsZ = 0.0f;
        this.renderOfsX = 0.0f;
        this.renderOfsY = 0.0f;
        this.renderOfsZ = 0.0f;
        this.renderRotX = 0.0f;
        this.renderRotY = 0.0f;
        this.renderRotZ = 0.0f;
        this.hasSeat = false;
        this.hasChest = false;
        this.isDeck = false;
        this.deckBoundingBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public EntityBoatPart(EntitySmallBoat _parent, String _name, int _modelIndex) {
        super(_parent.field_70170_p);
        logger.fine(SmallBoat.LogLevel, "%s: additional initialization for EntityBoatPart(%d)", this.field_70170_p.field_72995_K ? "client" : "server", this.field_70157_k);
        this.savedId = this.field_70157_k;
        this.field_70156_m = true;
        this.Parent = null;
        this.Name = "zombie";
        this.ModelIndex = -1;
        this.func_70105_a(0.95f, 0.95f);
        this.posOfsX = 0.0f;
        this.posOfsY = 0.0f;
        this.posOfsZ = 0.0f;
        this.renderOfsX = 0.0f;
        this.renderOfsY = 0.0f;
        this.renderOfsZ = 0.0f;
        this.renderRotX = 0.0f;
        this.renderRotY = 0.0f;
        this.renderRotZ = 0.0f;
        this.hasSeat = false;
        this.hasChest = false;
        this.isDeck = false;
        this.deckBoundingBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.setParent(_parent);
        this.setName((this.field_70170_p.field_72995_K ? "client" : "server") + "." + _name);
        this.setModelIndex(_modelIndex);
        logger.fine(SmallBoat.LogLevel, "%s: instantiated %s(%d)", _parent.field_70170_p.field_72995_K ? "client" : "server", this.Name, this.field_70157_k);
    }

    protected void func_70088_a() {
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeLong(this.ParentPersistentID.getMostSignificantBits());
        data.writeLong(this.ParentPersistentID.getLeastSignificantBits());
        if (this.Parent != null) {
            data.writeInt(this.Parent.field_70157_k);
        } else {
            data.writeInt(0);
        }
        data.writeInt(this.ModelIndex);
        data.writeBoolean(this.hasSeat);
        data.writeBoolean(this.hasChest);
        data.writeBoolean(this.isDeck);
        data.writeBoolean(this.canInteract);
        data.writeByte((int)this.BoundingFlags);
        data.writeFloat(this.posOfsX);
        data.writeFloat(this.posOfsY);
        data.writeFloat(this.posOfsZ);
        data.writeFloat(this.riderOfsX);
        data.writeFloat(this.riderOfsY);
        data.writeFloat(this.riderOfsZ);
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.ParentPersistentID = new UUID(data.readLong(), data.readLong());
        logger.fine(SmallBoat.LogLevel, "** child %d parent is %s", this.field_70157_k, this.ParentPersistentID.toString());
        this.parentId = data.readInt();
        if (this.parentId != 0) {
            this.setParent((EntitySmallBoat)this.field_70170_p.func_73045_a(this.parentId));
        } else {
            logger.fine(SmallBoat.LogLevel, "!! received spawn of child %d with invalid parentId", this.field_70157_k);
        }
        this.setModelIndex(data.readInt());
        this.setHasSeat(data.readBoolean());
        this.setHasChest(data.readBoolean());
        this.setIsDeck(data.readBoolean());
        this.canInteract = data.readBoolean();
        this.BoundingFlags = data.readByte();
        float x = data.readFloat();
        float y = data.readFloat();
        float z = data.readFloat();
        this.setPositionOffsets(x, y, z);
        x = data.readFloat();
        y = data.readFloat();
        z = data.readFloat();
        if (this.hasSeat) {
            this.setRiderOffsets(x, y, z);
        }
        if (this.Parent != null) {
            this.Parent.addPart(this);
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        if (this.Parent != null) {
            logger.fine(SmallBoat.LogLevel, "writing %s to NBT", this.Name);
            par1NBTTagCompound.func_74772_a("ParentUUID_MSB", this.Parent.getParentPersistentID().getMostSignificantBits());
            par1NBTTagCompound.func_74772_a("ParentUUID_LSB", this.Parent.getParentPersistentID().getLeastSignificantBits());
            par1NBTTagCompound.func_74778_a("Name", this.Name);
            par1NBTTagCompound.func_74768_a("ModelIndex", this.ModelIndex);
            par1NBTTagCompound.func_74757_a("HasSeat", this.hasSeat);
            par1NBTTagCompound.func_74757_a("HasChest", this.hasChest);
            par1NBTTagCompound.func_74757_a("IsDeck", this.isDeck);
            par1NBTTagCompound.func_74757_a("canInteract", this.canInteract);
            par1NBTTagCompound.func_74774_a("BoundingFlags", this.BoundingFlags);
            par1NBTTagCompound.func_74776_a("posOfsX", this.posOfsX);
            par1NBTTagCompound.func_74776_a("posOfsY", this.posOfsY);
            par1NBTTagCompound.func_74776_a("posOfsZ", this.posOfsZ);
            par1NBTTagCompound.func_74776_a("riderOfsX", this.riderOfsX);
            par1NBTTagCompound.func_74776_a("riderOfsY", this.riderOfsY);
            par1NBTTagCompound.func_74776_a("riderOfsZ", this.riderOfsZ);
        } else {
            logger.warning(SmallBoat.LogLevel, "!! attempted to write orphan %d to NBT", this.field_70157_k);
            this.func_70106_y();
        }
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.ParentPersistentID = new UUID(par1NBTTagCompound.func_74763_f("ParentUUID_MSB"), par1NBTTagCompound.func_74763_f("ParentUUID_LSB"));
        logger.fine(SmallBoat.LogLevel, "** child %d parent is %s", this.field_70157_k, this.ParentPersistentID.toString());
        this.setName(par1NBTTagCompound.func_74779_i("Name"));
        this.setModelIndex(par1NBTTagCompound.func_74762_e("ModelIndex"));
        this.setHasSeat(par1NBTTagCompound.func_74767_n("HasSeat"));
        this.setHasChest(par1NBTTagCompound.func_74767_n("HasChest"));
        this.setIsDeck(par1NBTTagCompound.func_74767_n("IsDeck"));
        this.canInteract = par1NBTTagCompound.func_74767_n("canInteract");
        this.BoundingFlags = par1NBTTagCompound.func_74771_c("BoundingFlags");
        this.posOfsX = par1NBTTagCompound.func_74760_g("posOfsX");
        this.posOfsY = par1NBTTagCompound.func_74760_g("posOfsY");
        this.posOfsZ = par1NBTTagCompound.func_74760_g("posOfsZ");
        this.riderOfsX = par1NBTTagCompound.func_74760_g("riderOfsX");
        this.riderOfsY = par1NBTTagCompound.func_74760_g("riderOfsY");
        this.riderOfsZ = par1NBTTagCompound.func_74760_g("riderOfsZ");
        if (this.ParentPersistentID.getMostSignificantBits() == 0L && this.ParentPersistentID.getLeastSignificantBits() == 0L) {
            logger.warning(SmallBoat.LogLevel, "!! read orphan %d from NBT", this.field_70157_k);
            this.func_70106_y();
        }
    }

    public void setParent(EntitySmallBoat _parent) {
        if (_parent != null) {
            logger.fine(SmallBoat.LogLevel, "%s: %d.setParent(%d)", this.field_70170_p.field_72995_K ? "client" : "server", this.field_70157_k, _parent.field_70157_k);
            this.Parent = _parent;
            this.parentId = this.Parent.field_70157_k;
            this.ParentPersistentID = _parent.getParentPersistentID();
        } else {
            logger.fine(SmallBoat.LogLevel, "%s: %d.setParent(null)", this.field_70170_p.field_72995_K ? "client" : "server", this.field_70157_k);
        }
    }

    public void setName(String _name) {
        logger.fine(SmallBoat.LogLevel, "%s: setName(%s)", this.field_70170_p.field_72995_K ? "client" : "server", _name);
        this.Name = _name;
    }

    public void setModelIndex(int _index) {
        this.ModelIndex = _index;
    }

    public void setHasSeat(boolean _hasSeat) {
        this.hasSeat = _hasSeat;
    }

    public void setHasChest(boolean _hasChest) {
        this.hasChest = _hasChest;
    }

    public void setIsDeck(boolean _isDeck) {
        logger.fine(SmallBoat.LogLevel, "%s: setIsDeck(%b)", this.field_70170_p.field_72995_K ? "client" : "server", _isDeck);
        this.isDeck = _isDeck;
    }

    public void setPositionOffsets(float _x, float _y, float _z) {
        this.posOfsX = _x;
        this.posOfsY = _y;
        this.posOfsZ = _z;
    }

    public void setRiderOffsets(float _x, float _y, float _z) {
        this.riderOfsX = _x;
        this.riderOfsY = _y;
        this.riderOfsZ = _z;
    }

    public void setRenderRotations(float _x, float _y, float _z) {
        this.renderRotX = _x;
        this.renderRotY = _y;
        this.renderRotZ = _z;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return par1Entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        if (this.isDeck) {
            return this.deckBoundingBox;
        }
        return this.field_70121_D;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.Parent != null) {
            logger.info(SmallBoat.LogLevel, "%s(%d).attackEntityFrom()", this.Name, this.field_70157_k);
            logger.fine(SmallBoat.LogLevel, "\tDamageSource=%s", par1DamageSource.func_76355_l());
            if (par1DamageSource.func_76355_l() == "thrown") {
                return false;
            }
            return this.Parent.attackEntityFromPart(par1DamageSource, par2);
        }
        return false;
    }

    public boolean func_70028_i(Entity par1Entity) {
        return this == par1Entity || this.Parent == par1Entity;
    }

    public void func_70108_f(Entity par1Entity) {
        if (this.isDeck) {
            if (this.Parent != null) {
                this.Parent.addPassenger(par1Entity);
            }
        } else if (this.Parent != null && par1Entity != this.Parent && !this.Parent.isRider(par1Entity) && !this.Parent.isChild(par1Entity) && par1Entity.func_70104_M()) {
            this.Parent.func_70108_f(par1Entity);
        }
    }

    public void applyBlockCollision(float x, float y, float z, float magnitude) {
        if (this.Parent != null) {
            this.Parent.applyBlockCollision(x, y, z, magnitude);
        }
    }

    public void func_70107_b(double par1, double par3, double par5) {
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        this.setBoundingBox();
    }

    public void func_70080_a(double par1, double par3, double par5, float par7, float par8) {
        this.field_70169_q = this.field_70165_t = par1;
        this.field_70167_r = this.field_70163_u = par3;
        this.field_70166_s = this.field_70161_v = par5;
        this.field_70126_B = this.field_70177_z = par7;
        this.field_70127_C = this.field_70125_A = par8;
        this.field_70139_V = 0.0f;
        double var9 = this.field_70126_B - par7;
        if (var9 < -180.0) {
            this.field_70126_B += 360.0f;
        }
        if (var9 >= 180.0) {
            this.field_70126_B -= 360.0f;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_70101_b(par7, par8);
        this.setBoundingBox();
    }

    public void func_70071_h_() {
        if (this.Parent == null) {
            for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                Entity ent = (Entity)this.field_70170_p.field_72996_f.get(i);
                if (!(ent instanceof EntitySmallBoat)) continue;
                EntitySmallBoat sm = (EntitySmallBoat)ent;
                UUID uuid = sm.getParentPersistentID();
                long msb1 = uuid.getMostSignificantBits();
                long lsb1 = uuid.getLeastSignificantBits();
                long msb2 = this.ParentPersistentID.getMostSignificantBits();
                long lsb2 = this.ParentPersistentID.getLeastSignificantBits();
                if (msb1 != msb2 || lsb1 != lsb2) continue;
                logger.finer(SmallBoat.LogLevel, "%s: found smallboat %s ", this.field_70170_p.field_72995_K ? "client" : "server", uuid.toString());
                this.setParent(sm);
                break;
            }
            if (this.Parent != null) {
                this.Parent.addPart(this);
            } else {
                --this.SuicideCounter;
                if (this.SuicideCounter <= 0) {
                    logger.severe(SmallBoat.LogLevel, "!! child %d couldn't find parent %s -- GOODBYE, CRUEL WORLD!", this.field_70157_k, this.ParentPersistentID.toString());
                    this.func_70106_y();
                }
                return;
            }
        }
        if (this.savedId != this.field_70157_k) {
            this.savedId = this.field_70157_k;
            if (this.field_70170_p.field_72995_K) {
                this.Parent.updateChildIds();
            }
        }
        this.setBoundingBox();
        super.func_70071_h_();
        if (this.field_70124_G || this.field_70122_E) {
            this.Parent.field_70122_E = true;
        }
        if (!this.field_70170_p.field_72995_K) {
            List var16 = this.field_70170_p.func_72839_b((Entity)this, this.func_70114_g(this));
            if (var16 != null && !var16.isEmpty()) {
                for (Entity var18 : var16) {
                    if (var18 == this.field_70153_n || this.Parent.isChild(var18)) continue;
                    var18.func_70108_f((Entity)this);
                }
            }
            for (int ofsx = -1; ofsx < 2; ++ofsx) {
                for (int ofsz = -1; ofsz < 2; ++ofsz) {
                    int x = MathHelper.func_76128_c((double)(this.field_70165_t + (double)ofsx));
                    int z = MathHelper.func_76128_c((double)(this.field_70161_v + (double)ofsz));
                    for (int ofsy = -1; ofsy < 1; ++ofsy) {
                        int y = MathHelper.func_76128_c((double)this.field_70163_u) + ofsy;
                        int id = this.field_70170_p.func_72798_a(x, y, z);
                        int metadata = this.field_70170_p.func_72805_g(x, y, z);
                        boolean isAir = this.field_70170_p.func_72799_c(x, y, z);
                        if (!isAir && ofsx == 0 && ofsz == 0) {
                            this.field_70124_G = true;
                        }
                        if (isAir) continue;
                        if (id == Block.field_72037_aS.field_71990_ca) {
                            this.field_70170_p.func_94578_a(x, y, z, true);
                            continue;
                        }
                        if (id == Block.field_71979_v.field_71990_ca) {
                            this.applyBlockCollision(x, y, z, 0.75f);
                            continue;
                        }
                        if (id == Block.field_71980_u.field_71990_ca) {
                            this.applyBlockCollision(x, y, z, 0.75f);
                            continue;
                        }
                        if (id == Block.field_71939_E.field_71990_ca) {
                            this.applyBlockCollision(x, y, z, 0.75f);
                            continue;
                        }
                        if (id == Block.field_72041_aW.field_71990_ca) {
                            this.applyBlockCollision(x, y, z, 0.75f);
                            continue;
                        }
                        if (id == Block.field_72092_bO.field_71990_ca) {
                            this.applyBlockCollision(x, y, z, 0.5f);
                            continue;
                        }
                        if (id == Block.field_71943_B.field_71990_ca) {
                            this.field_70124_G = false;
                            continue;
                        }
                        if (id == Block.field_71942_A.field_71990_ca) {
                            this.field_70124_G = false;
                            continue;
                        }
                        if (id == Block.field_71991_bz.field_71990_ca) {
                            Block.field_71991_bz.func_71914_a(this.field_70170_p, x, y, z, metadata, 0.3f, 0);
                            this.field_70170_p.func_94578_a(x, y, z, true);
                            continue;
                        }
                        if (id == Block.field_71998_bu.field_71990_ca) {
                            Block.field_71998_bu.func_71914_a(this.field_70170_p, x, y, z, metadata, 0.3f, 0);
                            this.field_70170_p.func_94578_a(x, y, z, true);
                            continue;
                        }
                        if (id == 0) continue;
                        this.applyBlockCollision(x, y, z, 0.75f);
                    }
                }
            }
        }
    }

    public byte getBoundingFlags() {
        return this.BoundingFlags;
    }

    public void setBoundingFlags(byte _flags) {
        this.BoundingFlags = _flags;
    }

    protected void setBoundingBox() {
        double x1 = this.field_70165_t - 0.5;
        double y1 = this.field_70163_u - 0.5;
        double z1 = this.field_70161_v - 0.5;
        double x2 = this.field_70165_t + 0.5;
        double y2 = this.field_70163_u + 0.5;
        double z2 = this.field_70161_v + 0.5;
        switch (this.BoundingFlags) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 16: {
                y1 += 0.75;
                break;
            }
            case 32: {
                y2 -= 0.75;
                break;
            }
            case 64: {
                y2 -= 0.5;
            }
        }
        this.field_70121_D.func_72324_b(x1, y1, z1, x2, y2, z2);
        if (this.isDeck) {
            this.deckBoundingBox.func_72324_b(x1, y1, z1, x2, y2 - 0.25, z2);
        }
    }

    public boolean func_130002_c(EntityPlayer par1EntityPlayer) {
        if (!this.Parent.isUpdating) {
            return false;
        }
        logger.info(SmallBoat.LogLevel, "%s.%s.interact(%d)", this.field_70170_p.field_72995_K ? "client" : "server", this.Name, this.field_70157_k);
        if (this.field_70170_p.field_72995_K && this.Parent != null) {
            boolean shifted;
            boolean bl = shifted = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (this.Parent.isRider((Entity)par1EntityPlayer)) {
                if (this.canInteract) {
                    if (shifted) {
                        this.Parent.sendDismountRequest((Entity)par1EntityPlayer);
                    } else if (this.hasChest) {
                        this.Parent.sendOpenChest(this, (Entity)par1EntityPlayer);
                    } else if (this.hasSeat) {
                        this.Parent.sendMountRequest(this, (Entity)par1EntityPlayer, (byte)0);
                    } else if (this.Parent.field_70153_n == null) {
                        this.Parent.sendMountRequest(null, (Entity)par1EntityPlayer, (byte)0);
                    }
                }
            } else if (this.canInteract && this.hasChest) {
                this.Parent.sendOpenChest(this, (Entity)par1EntityPlayer);
            } else if (!shifted) {
                logger.fine(SmallBoat.LogLevel, "\t** requesting a seat", new Object[0]);
                this.Parent.sendMountRequest(null, (Entity)par1EntityPlayer, (byte)0);
            } else {
                if (!this.Parent.isRider((Entity)par1EntityPlayer)) {
                    logger.fine(SmallBoat.LogLevel, "\t** object mismatch: %d not a rider of %d", par1EntityPlayer.field_70157_k, this.Parent.field_70157_k);
                } else {
                    logger.fine(SmallBoat.LogLevel, "\t** object match: %d is a rider of %d", par1EntityPlayer.field_70157_k, this.Parent.field_70157_k);
                }
                if (!this.Parent.isRider(par1EntityPlayer.field_70157_k)) {
                    logger.fine(SmallBoat.LogLevel, "\t** ID mismatch: %d not a rider of %d", par1EntityPlayer.field_70157_k, this.Parent.field_70157_k);
                } else {
                    logger.fine(SmallBoat.LogLevel, "\t** ID match: %d is a rider of %d", par1EntityPlayer.field_70157_k, this.Parent.field_70157_k);
                }
            }
        }
        return true;
    }

    public void OpenChest(EntityPlayer par1EntityPlayer) {
        logger.info(SmallBoat.LogLevel, "%s.OpenChest(...)", this.field_70170_p.field_72995_K ? "client" : "server");
        if (this.Parent.isRider((Entity)par1EntityPlayer) && this instanceof EntityBoatChest) {
            par1EntityPlayer.func_71007_a((IInventory)((EntityBoatChest)this));
        }
    }

    public double func_70042_X() {
        return 0.0;
    }

    public void func_70098_U() {
        logger.finest(SmallBoat.LogLevel, "%s.part.updateRidden()", this.field_70170_p.field_72995_K ? "client" : "server");
        super.func_70098_U();
    }

    public void func_70043_V() {
        if (this.hasSeat && this.field_70153_n != null) {
            double cos1 = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            double sin1 = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            double cos2 = Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0);
            double sin2 = Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0);
            double var1 = cos1 * (double)this.riderOfsX + cos2 * (double)this.riderOfsZ;
            double var3 = sin1 * (double)this.riderOfsX + sin2 * (double)this.riderOfsZ;
            this.field_70153_n.func_70107_b(this.field_70165_t + var1, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v + var3);
        }
    }

    protected void func_70076_C() {
        if (this.field_70153_n != null) {
            this.Parent.Dismount(this.field_70153_n.field_70157_k);
        }
        this.func_70106_y();
    }
}

