/*
 * Decompiled with CFR 0.152.
 */
package mods.awger.smallboat;

import net.minecraft.entity.Entity;

public class PassengerData {
    protected Entity Passenger;
    protected Entity Vehicle;
    protected double Xofs;
    protected double Yofs;
    protected double Zofs;
    protected int Countdown;

    PassengerData(Entity _passenger, Entity _vehicle) {
        this.Passenger = _passenger;
        this.Vehicle = _vehicle;
        this.updatePassengerOffset();
        this.resetCountdown();
    }

    void updatePassengerOffset() {
        if (this.Passenger != null && this.Vehicle != null) {
            double x = this.Passenger.field_70165_t - this.Vehicle.field_70165_t;
            double y = this.Passenger.field_70163_u - this.Vehicle.field_70163_u;
            double z = this.Passenger.field_70161_v - this.Vehicle.field_70161_v;
            double h = Math.sqrt(x * x + z * z);
            double angle = 360.0f - this.Vehicle.field_70177_z;
            double cos1 = Math.cos(angle * Math.PI / 180.0);
            double sin1 = Math.sin(angle * Math.PI / 180.0);
            double cos2 = Math.cos((angle + 90.0) * Math.PI / 180.0);
            double sin2 = Math.sin((angle + 90.0) * Math.PI / 180.0);
            this.Xofs = cos1 * x - sin1 * z;
            this.Zofs = cos1 * z + sin1 * x;
            this.Yofs = y - 0.15;
        }
        --this.Countdown;
    }

    void updatePassengerPosition() {
        if (this.Passenger != null && this.Vehicle != null && this.Vehicle.field_70153_n != this.Passenger) {
            double cos1 = Math.cos((double)this.Vehicle.field_70177_z * Math.PI / 180.0);
            double sin1 = Math.sin((double)this.Vehicle.field_70177_z * Math.PI / 180.0);
            double cos2 = Math.cos((double)(this.Vehicle.field_70177_z + 90.0f) * Math.PI / 180.0);
            double sin2 = Math.sin((double)(this.Vehicle.field_70177_z + 90.0f) * Math.PI / 180.0);
            double var1 = cos1 * this.Xofs + cos2 * this.Zofs;
            double var3 = sin1 * this.Xofs + sin2 * this.Zofs;
            this.Passenger.func_70080_a(this.Vehicle.field_70165_t + var1, this.Passenger.field_70163_u, this.Vehicle.field_70161_v + var3, this.Passenger.field_70177_z, this.Passenger.field_70125_A);
            this.Passenger.field_70159_w = 0.0;
            this.Passenger.field_70181_x = 0.0;
            this.Passenger.field_70179_y = 0.0;
        }
    }

    void resetCountdown() {
        this.Countdown = 10;
    }

    boolean isExpired() {
        return this.Countdown <= 0;
    }
}

