/*
 * Decompiled with CFR 0.152.
 */
package mods.awger.smallboat;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import mods.awger.logger;
import mods.awger.smallboat.EntitySmallBoat;
import mods.awger.smallboat.SmallBoat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ServerPacketHandler
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player p) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        byte type = 0;
        byte flags = 0;
        EntityPlayerMP player = (EntityPlayerMP)p;
        World w = player.field_70170_p;
        WorldServer ws = player.func_71121_q();
        try {
            int id = dis.readInt();
            int pid = dis.readInt();
            Entity parent = ws.func_73045_a(pid);
            if (parent == null) {
                logger.fine(SmallBoat.LogLevel, "!! parent object %d not found", pid);
                return;
            }
            type = dis.readByte();
            switch (type) {
                case 2: {
                    int i = dis.readInt();
                    ((EntitySmallBoat)parent).setFlags(i);
                    break;
                }
                case 4: {
                    logger.info(SmallBoat.LogLevel, "server.ptMount", new Object[0]);
                    flags = dis.readByte();
                    int cid = dis.readInt();
                    int eid = dis.readInt();
                    logger.info(SmallBoat.LogLevel, "\tentity %d mounting server.SmallBoat(%d, %d, %02X)", eid, pid, cid, flags);
                    ((EntitySmallBoat)parent).Mount(cid, eid, flags);
                    break;
                }
                case 5: {
                    logger.info(SmallBoat.LogLevel, "server.ptDismount", new Object[0]);
                    int eid = dis.readInt();
                    logger.info(SmallBoat.LogLevel, "\tentity %d dismounting from server.SmallBoat(%d)", eid, pid);
                    ((EntitySmallBoat)parent).Dismount(eid);
                    break;
                }
                case 6: {
                    int cid = dis.readInt();
                    int eid = dis.readInt();
                    logger.info(SmallBoat.LogLevel, "\tentity %d opening chest on server.SmallBoat(%d,%d)", eid, pid, cid);
                    ((EntitySmallBoat)parent).OpenChest(cid, eid);
                    break;
                }
                case 3: {
                    logger.finest(SmallBoat.LogLevel, "server.ptSetPosition", new Object[0]);
                    double x = dis.readDouble();
                    double y = dis.readDouble();
                    double z = dis.readDouble();
                    float yaw = dis.readFloat();
                    float pitch = dis.readFloat();
                    double mx = dis.readDouble();
                    double my = dis.readDouble();
                    double mz = dis.readDouble();
                    ((EntitySmallBoat)parent).setPositionAndRotation3(x, y, z, yaw, pitch, 3);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

