/*
 * Decompiled with CFR 0.152.
 */
package mods.awger.whitehall;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.awger.logger;
import mods.awger.whitehall.Whitehall;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;

@SideOnly(value=Side.CLIENT)
public class ModelHullBottom
extends ModelBase {
    public static final int NUM_BOXES = 27;
    public ModelRenderer[] Boxes;

    public ModelHullBottom() {
        logger.fine(Whitehall.LogLevel, "ModelHullBottom()", new Object[0]);
        this.Boxes = new ModelRenderer[27];
        this.Boxes[0] = new ModelRenderer((ModelBase)this, 0, 8);
        for (int i = 1; i < 27; ++i) {
            this.Boxes[i] = new ModelRenderer((ModelBase)this, 0, 0);
        }
        int blocksize = 16;
        int width = blocksize * 2;
        int length = blocksize * 6;
        int height = blocksize * 2;
        int thickness = 2;
        int draft = blocksize / 2;
        float right_edge = width / 2;
        float left_edge = -right_edge;
        float stern_edge = length / 2;
        float bow_edge = -stern_edge;
        float x = -((float)blocksize * 3.5f) + (float)thickness;
        float y = draft - 15;
        float z = thickness / 2;
        int idx = 0;
        idx = this.addBox(idx, -((float)blocksize * 3.5f) + (float)thickness, draft + 2, -(thickness / 2), length - thickness, 4, thickness);
        x = -((float)blocksize * 3.5f) + 4.0f;
        y = draft - 2;
        z = thickness / 2;
        idx = this.addMirrorZ(idx, x, y, z, length - thickness * 2, 4, 1);
        idx = this.addMirrorZ(idx, x += 6.0f, y += 1.0f, z += 1.0f, 2, 1, thickness);
        idx = this.addMirrorZ(idx, x += 2.0f, y += 1.0f, z += 0.0f, 62, 1, 3);
        idx = this.addMirrorZ(idx, x += 62.0f, y -= 1.0f, z += 0.0f, 10, 1, 3);
        idx = this.addMirrorZ(idx, x += 10.0f, y -= 1.0f, z += 0.0f, 8, 1, 3);
        idx = this.addMirrorZ(idx, x += 8.0f, y -= 1.0f, z += 0.0f, 4, 1, 3);
        x = -((float)blocksize * 3.5f) + 12.0f;
        y = draft - 1;
        z = 5.0f;
        idx = this.addMirrorZ(idx, x, y, z, 4, 2, 1);
        idx = this.addMirrorZ(idx, x += 4.0f, y += 1.0f, z += 0.0f, 8, 1, 3);
        idx = this.addMirrorZ(idx, x += 8.0f, y += 0.0f, z += 0.0f, 40, 1, 5);
        idx = this.addMirrorZ(idx, x += 40.0f, y -= 1.0f, z += 0.0f, 10, 1, 5);
        idx = this.addMirrorZ(idx, x += 10.0f, y -= 1.0f, z += 0.0f, 10, 1, 5);
        idx = this.addMirrorZ(idx, x += 10.0f, y -= 1.0f, z += 0.0f, 8, 1, 4);
        if ((idx = this.addMirrorZ(idx, x += 8.0f, y -= 1.0f, z += 0.0f, 4, 1, 3)) != 27) {
            logger.finer(Whitehall.LogLevel, "\t** created %d boxes (%d extra)", idx, 27 - idx);
        }
    }

    private int addBox(int _index, float x, float y, float z, int xSize, int ySize, int zSize) {
        this.Boxes[_index++].func_78790_a(x, y, z, xSize, ySize, zSize, 0.0f);
        return _index;
    }

    private int addMirrorZ(int _index, float x, float y, float z, int xSize, int ySize, int zSize) {
        this.Boxes[_index++].func_78790_a(x, y, z, xSize, ySize, zSize, 0.0f);
        z = z * -1.0f - (float)zSize;
        this.Boxes[_index++].func_78790_a(x, y, z, xSize, ySize, zSize, 0.0f);
        return _index;
    }

    private void MirrorZ(int port_index, int starboard_index, float x, float y, float z, int xSize, int ySize, int zSize) {
        this.Boxes[port_index].func_78790_a(x, y, z, xSize, ySize, zSize, 0.0f);
        z = z * -1.0f - (float)zSize;
        this.Boxes[starboard_index].func_78790_a(x, y, z, xSize, ySize, zSize, 0.0f);
    }

    public void func_78088_a(Entity par1Entity, float par2, float par3, float par4, float par5, float par6, float par7) {
        for (int i = 0; i < 27; ++i) {
            this.Boxes[i].func_78785_a(par7);
        }
    }
}

