/*
 * Decompiled with CFR 0.152.
 */
package mods.awger.whitehall;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.awger.logger;
import mods.awger.whitehall.Whitehall;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;

@SideOnly(value=Side.CLIENT)
public class ModelWhitehall
extends ModelBase {
    public static final int NUM_BOXES = 66;
    public ModelRenderer[] boatSides;

    public ModelWhitehall() {
        logger.fine(Whitehall.LogLevel, "ModelWhitehall()", new Object[0]);
        this.boatSides = new ModelRenderer[66];
        this.boatSides[0] = new ModelRenderer((ModelBase)this, 0, 8);
        for (int i = 1; i < 66; ++i) {
            this.boatSides[i] = new ModelRenderer((ModelBase)this, 0, 0);
        }
        int blocksize = 16;
        int width = blocksize * 2;
        int length = blocksize * 6;
        int height = blocksize * 2;
        int thickness = 2;
        int draft = blocksize / 2;
        float right_edge = width / 2;
        float left_edge = -right_edge;
        float stern_edge = length / 2;
        float bow_edge = -stern_edge;
        float x = -((float)blocksize * 3.5f) + (float)thickness;
        float y = draft - 15;
        float z = thickness / 2;
        int idx = 0;
        idx = this.addMirrorZ(idx, x, y, z, thickness, 5, thickness);
        idx = this.addMirrorZ(idx, x += (float)thickness, y += 0.0f, z += (float)(thickness / 2), thickness, 6, thickness);
        idx = this.addMirrorZ(idx, x += (float)thickness, y += 0.0f, z += (float)thickness, thickness, 7, thickness);
        idx = this.addMirrorZ(idx, x += (float)thickness, y += 1.0f, z += (float)thickness, 4, 8, thickness);
        idx = this.addMirrorZ(idx, x += 4.0f, y += 0.0f, z += (float)thickness, 4, 9, thickness);
        idx = this.addMirrorZ(idx, x += 4.0f, y += 0.0f, z += (float)thickness, 8, 9, thickness);
        idx = this.addMirrorZ(idx, x += 8.0f, y += 0.0f, z += (float)thickness, 8, 9, thickness);
        idx = this.addMirrorZ(idx, x += 8.0f, y += 1.0f, z += (float)thickness, 32, 8, thickness);
        idx = this.addMirrorZ(idx, x += 32.0f, y, z -= (float)thickness, 10, 8, thickness);
        idx = this.addMirrorZ(idx, x += 10.0f, y -= 1.0f, z -= 1.0f, 10, 8, thickness);
        idx = this.addMirrorZ(idx, x += 10.0f, y -= 1.0f, z -= 1.0f, 8, 8, thickness);
        idx = this.addMirrorZ(idx, x += 8.0f, y -= 1.0f, z -= 1.0f, 4, 8, thickness);
        x = -((float)blocksize * 3.5f) + (float)thickness;
        y = draft - 10;
        z = thickness / 2;
        idx = this.addMirrorZ(idx, x, y, z, thickness * 2, 4, thickness);
        idx = this.addMirrorZ(idx, x += (float)(thickness * 2), y += 1.0f, z += (float)(thickness / 2), thickness, 4, thickness);
        idx = this.addMirrorZ(idx, x += (float)thickness, y += 1.0f, z += (float)thickness, thickness, 4, thickness);
        idx = this.addMirrorZ(idx, x += (float)thickness, y += 1.0f, z += (float)thickness, 6, 3, thickness);
        idx = this.addMirrorZ(idx, x += 6.0f, y += 1.0f, z += (float)thickness, 8, 2, thickness);
        idx = this.addMirrorZ(idx, x += 8.0f, y += 1.0f, z += (float)thickness, 8, 3, thickness);
        idx = this.addMirrorZ(idx, x += 8.0f, y += 0.0f, z += (float)thickness, 32, 4, thickness);
        idx = this.addMirrorZ(idx, x += 32.0f, y += 0.0f, z -= (float)thickness, 10, 2, thickness);
        idx = this.addMirrorZ(idx, x += 10.0f, y -= 1.0f, z -= 0.0f, 10, 2, thickness);
        idx = this.addMirrorZ(idx, x += 10.0f, y -= 1.0f, z -= 1.0f, 8, 2, thickness);
        idx = this.addMirrorZ(idx, x += 8.0f, y -= 1.0f, z -= 2.0f, 4, 2, 3);
        x = -((float)blocksize * 3.5f) + (float)thickness;
        y = draft - 6;
        z = thickness / 2;
        idx = this.addMirrorZ(idx, x, y, z, thickness * 3, 4, 1);
        idx = this.addMirrorZ(idx, x += (float)(thickness * 3), y += 1.0f, z += 1.0f, 2, 4, thickness);
        idx = this.addMirrorZ(idx, x += 2.0f, y += 1.0f, z += 2.0f, 2, 4, thickness);
        idx = this.addMirrorZ(idx, x += 2.0f, y += 0.0f, z += 2.0f, 4, 4, thickness);
        idx = this.addMirrorZ(idx, x += 4.0f, y += 0.0f, z += 2.0f, 8, 4, thickness);
        idx = this.addMirrorZ(idx, x += 8.0f, y += 2.0f, z += 2.0f, 40, 2, thickness);
        idx = this.addMirrorZ(idx, x += 40.0f, y -= 1.0f, z -= 0.0f, 10, 2, thickness);
        idx = this.addMirrorZ(idx, x += 10.0f, y -= 1.0f, z -= 1.0f, 10, 2, thickness);
        idx = this.addMirrorZ(idx, x += 10.0f, y -= 1.0f, z -= 1.0f, 8, 2, thickness);
        if ((idx = this.addMirrorZ(idx, x += 8.0f, y -= 1.0f, z -= 1.0f, 4, 2, thickness)) != 66) {
            logger.finer(Whitehall.LogLevel, "\t** created %d boxes (%d extra)", idx, 66 - idx);
        }
    }

    private int addMirrorZ(int _index, float x, float y, float z, int xSize, int ySize, int zSize) {
        this.boatSides[_index++].func_78790_a(x, y, z, xSize, ySize, zSize, 0.0f);
        z = z * -1.0f - (float)zSize;
        this.boatSides[_index++].func_78790_a(x, y, z, xSize, ySize, zSize, 0.0f);
        return _index;
    }

    private void MirrorZ(int port_index, int starboard_index, float x, float y, float z, int xSize, int ySize, int zSize) {
        this.boatSides[port_index].func_78790_a(x, y, z, xSize, ySize, zSize, 0.0f);
        z = z * -1.0f - (float)zSize;
        this.boatSides[starboard_index].func_78790_a(x, y, z, xSize, ySize, zSize, 0.0f);
    }

    public void func_78088_a(Entity par1Entity, float par2, float par3, float par4, float par5, float par6, float par7) {
        for (int i = 0; i < 66; ++i) {
            this.boatSides[i].func_78785_a(par7);
        }
    }
}

