/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.blocks;

import com.davenonymous.bonsaitrees3.blocks.BonsaiPotBlockEntity;
import com.davenonymous.bonsaitrees3.blocks.BonsaiPotContainer;
import com.davenonymous.bonsaitrees3.compat.top.ITopInfoProvider;
import com.davenonymous.bonsaitrees3.config.CommonConfig;
import com.davenonymous.bonsaitrees3.libnonymous.base.BaseBlock;
import com.davenonymous.bonsaitrees3.libnonymous.base.BaseLanguageProvider;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees3.registry.soil.SoilInfo;
import com.davenonymous.bonsaitrees3.setup.CustomBlockStateProperties;
import com.davenonymous.bonsaitrees3.setup.Registration;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;

public class BonsaiPotBlock
extends BaseBlock
implements BonemealableBlock,
ITopInfoProvider {
    private final VoxelShape shape = Shapes.m_83048_((double)0.065f, (double)0.005f, (double)0.065f, (double)0.935f, (double)0.185f, (double)0.935f);

    public BonsaiPotBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56740_).m_60978_(2.0f).m_60999_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)CustomBlockStateProperties.COLOR, (Comparable)Integer.valueOf(DyeColor.LIGHT_GRAY.m_41060_())));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CustomBlockStateProperties.COLOR});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        DyeColor color;
        BlockState state = super.m_5573_(context);
        ItemStack offHandItemStack = context.m_43723_().m_21120_(InteractionHand.OFF_HAND);
        if (Tags.Items.DYES.m_8110_((Object)offHandItemStack.m_41720_()) && (color = DyeColor.getColor((ItemStack)offHandItemStack)) != null) {
            state = (BlockState)state.m_61124_((Property)CustomBlockStateProperties.COLOR, (Comparable)Integer.valueOf(color.m_41060_()));
        }
        return state;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        boolean blockChanged = !pState.m_60713_(pNewState.m_60734_());
        BonsaiPotBlockEntity tile = (BonsaiPotBlockEntity)pLevel.m_7702_(pPos);
        if (!blockChanged || tile == null || pLevel.m_5776_()) {
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
            return;
        }
        tile.dropItemStackContents();
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, final BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack newStack;
        DyeColor color;
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6047_()) {
            return InteractionResult.PASS;
        }
        ItemStack playerStack = player.m_21120_(hand);
        BonsaiPotBlockEntity pot = (BonsaiPotBlockEntity)level.m_7702_(pos);
        SoilInfo soilInfo = Registration.RECIPE_HELPER_SOIL.getSoilForItem(level, playerStack);
        if (soilInfo != null && !pot.hasSoil()) {
            if (player.m_7500_()) {
                ItemStack soilStack = playerStack.m_41777_();
                soilStack.m_41764_(1);
                pot.setSoil(soilStack);
            } else {
                pot.setSoil(playerStack.m_41620_(1));
            }
            pot.m_6596_();
            return InteractionResult.SUCCESS;
        }
        SaplingInfo saplingInfo = Registration.RECIPE_HELPER_SAPLING.getSaplingInfoForItem(level, playerStack);
        if (saplingInfo != null && !pot.hasSapling()) {
            if (player.m_7500_()) {
                ItemStack saplingStack = playerStack.m_41777_();
                saplingStack.m_41764_(1);
                pot.setSapling(saplingStack);
            } else {
                pot.setSapling(playerStack.m_41620_(1));
            }
            pot.m_6596_();
            return InteractionResult.SUCCESS;
        }
        if (Tags.Items.DYES.m_8110_((Object)playerStack.m_41720_()) && (color = DyeColor.getColor((ItemStack)playerStack)) != null) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CustomBlockStateProperties.COLOR, (Comparable)Integer.valueOf(color.m_41060_())), 2);
            return InteractionResult.SUCCESS;
        }
        if (BonsaiPotBlockEntity.isUpgradeItem(playerStack) && (!(newStack = ItemHandlerHelper.insertItem((IItemHandler)pot.getUpgradeItemStacks(), (ItemStack)playerStack, (boolean)true)).m_150930_(playerStack.m_41720_()) || newStack.m_41613_() != playerStack.m_41613_())) {
            player.m_21008_(hand, ItemHandlerHelper.insertItem((IItemHandler)pot.getUpgradeItemStacks(), (ItemStack)playerStack, (boolean)false));
            return InteractionResult.SUCCESS;
        }
        MenuProvider menuProvider = new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent(BaseLanguageProvider.getContainerLanguageKey((MenuType)Registration.BONSAI_POT_CONTAINER.get()));
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
                return new BonsaiPotContainer(pContainerId, pos, pInventory, pPlayer);
            }
        };
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)menuProvider, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BonsaiPotBlockEntity(pos, state);
    }

    public VoxelShape m_7952_(BlockState p_60578_, BlockGetter p_60579_, BlockPos p_60580_) {
        return this.shape;
    }

    public VoxelShape m_5939_(BlockState p_60572_, BlockGetter p_60573_, BlockPos p_60574_, CollisionContext p_60575_) {
        return this.shape;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shape;
    }

    public boolean m_7370_(BlockGetter pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        if (!((Boolean)CommonConfig.allowBonemeal.get()).booleanValue()) {
            return false;
        }
        BonsaiPotBlockEntity pot = (BonsaiPotBlockEntity)pLevel.m_7702_(pPos);
        if (pot == null) {
            return false;
        }
        if (!pot.hasSoil() || !pot.hasSapling()) {
            return false;
        }
        return pot.isGrowing();
    }

    public boolean m_5491_(Level pLevel, Random pRandom, BlockPos pPos, BlockState pState) {
        return pRandom.nextDouble() < (Double)CommonConfig.bonemealSuccessChance.get();
    }

    public void m_7719_(ServerLevel pLevel, Random pRandom, BlockPos pPos, BlockState pState) {
        BonsaiPotBlockEntity pot = (BonsaiPotBlockEntity)pLevel.m_7702_(pPos);
        if (pot == null) {
            return;
        }
        pot.boostProgress();
    }

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player player, Level level, BlockState blockState, IProbeHitData iProbeHitData) {
        if (!(level.m_7702_(iProbeHitData.getPos()) instanceof BonsaiPotBlockEntity)) {
            return;
        }
        BonsaiPotBlockEntity pot = (BonsaiPotBlockEntity)level.m_7702_(iProbeHitData.getPos());
        if (pot.hasSapling()) {
            iProbeInfo.horizontal().item(pot.getSapling()).itemLabel(pot.getSapling());
        }
        if (pot.hasSoil()) {
            SoilInfo soilInfo = pot.getSoilInfo();
            if (soilInfo.isFluid) {
                Item bucketItem = soilInfo.fluidState.m_76152_().m_6859_();
                ItemStack bucketStack = new ItemStack((ItemLike)bucketItem);
                iProbeInfo.horizontal().item(bucketStack).itemLabel(bucketStack);
            } else {
                ItemStack soilStack = new ItemStack((ItemLike)pot.getSoilBlock().m_60734_());
                iProbeInfo.horizontal().item(soilStack).itemLabel(soilStack);
            }
        }
        if (pot.hasSapling()) {
            iProbeInfo.progress((int)(pot.getProgress() * 100.0), 100, iProbeInfo.defaultProgressStyle().suffix("%").filledColor(-12277180).alternateFilledColor(-12277180).backgroundColor(-8165037));
        }
    }
}

