/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.client;

import com.davenonymous.bonsaitrees3.blocks.BonsaiPotBlockEntity;
import com.davenonymous.bonsaitrees3.client.BonsaiPotModelLoader;
import com.davenonymous.bonsaitrees3.libnonymous.render.QuadBaker;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class BonsaiPotBakedModel
implements IDynamicBakedModel {
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelState modelState;
    private final ItemOverrides overrides;
    private final ItemTransforms itemTransforms;
    private final Map<BlockState, List<BakedQuad>> quadCache = new HashMap<BlockState, List<BakedQuad>>();
    private final Map<FluidState, List<BakedQuad>> fluidQuadCache = new HashMap<FluidState, List<BakedQuad>>();
    private final BakedModel potModel;

    public BonsaiPotBakedModel(ModelState modelState, Function<Material, TextureAtlasSprite> spriteGetter, ItemOverrides overrides, ItemTransforms itemTransforms, BakedModel potModel) {
        this.modelState = modelState;
        this.spriteGetter = spriteGetter;
        this.overrides = overrides;
        this.itemTransforms = itemTransforms;
        this.potModel = potModel;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        boolean hasFluid;
        RenderType layer = MinecraftForgeClient.getRenderType();
        if (side != null || layer != null && !layer.equals(RenderType.m_110451_())) {
            return Collections.emptyList();
        }
        BlockState soilBlock = (BlockState)extraData.getData(BonsaiPotBlockEntity.SOIL_BLOCK);
        FluidState fluidBlock = (FluidState)extraData.getData(BonsaiPotBlockEntity.FLUID_BLOCK);
        boolean hasBlock = soilBlock != null && !soilBlock.m_60795_();
        boolean bl = hasFluid = fluidBlock != null && !fluidBlock.m_76178_();
        if (!hasFluid && !hasBlock) {
            return this.potModel.getQuads(state, side, rand, extraData);
        }
        if (hasBlock) {
            if (!this.quadCache.containsKey(soilBlock)) {
                ArrayList potQuads = new ArrayList(this.potModel.getQuads(state, side, rand, extraData));
                Transformation transformation = new Transformation(Matrix4f.m_27632_((float)0.0625f, (float)0.0625f, (float)0.0625f));
                transformation = transformation.m_121096_(new Transformation(Matrix4f.m_27653_((float)2.0f, (float)1.1f, (float)2.0f)));
                transformation = transformation.m_121096_(new Transformation(Matrix4f.m_27632_((float)12.0f, (float)1.0f, (float)12.0f)));
                QuadTransformer quadTransformer = new QuadTransformer(transformation);
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(soilBlock);
                model.getQuads(soilBlock, Direction.UP, rand, (IModelData)EmptyModelData.INSTANCE).stream().map(arg_0 -> ((QuadTransformer)quadTransformer).processOne(arg_0)).forEach(potQuads::add);
                this.quadCache.put(soilBlock, potQuads);
            }
            return this.quadCache.get(soilBlock);
        }
        if (hasFluid) {
            if (!this.fluidQuadCache.containsKey(fluidBlock)) {
                ArrayList<BakedQuad> potQuads = new ArrayList<BakedQuad>(this.potModel.getQuads(state, side, rand, extraData));
                ResourceLocation textureLocation = fluidBlock.m_76152_().getAttributes().getStillTexture();
                TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(textureLocation);
                int i = fluidBlock.m_76152_().getAttributes().getColor();
                float alpha = (float)(i >> 24 & 0xFF) / 255.0f;
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                float height = 0.125f;
                BakedQuad quad = QuadBaker.createQuad(QuadBaker.v(0.1f, height, 0.1f), QuadBaker.v(0.1f, height, 0.9f), QuadBaker.v(0.9f, height, 0.9f), QuadBaker.v(0.9f, height, 0.1f), Transformation.m_121093_(), sprite, r, g, b, alpha);
                potQuads.add(quad);
                this.fluidQuadCache.put(fluidBlock, potQuads);
            }
            return this.fluidQuadCache.get(fluidBlock);
        }
        return Collections.emptyList();
    }

    private BakedQuad untintQuad(BakedQuad input) {
        return new BakedQuad(input.m_111303_(), -1, input.m_111306_(), input.m_173410_(), input.m_111307_());
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.spriteGetter.apply(BonsaiPotModelLoader.BONSAIPOT_BRICKS_MATERIAL);
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public ItemTransforms m_7442_() {
        return this.itemTransforms;
    }
}

