/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.client;

import com.davenonymous.bonsaitrees3.blocks.BonsaiPotBlockEntity;
import com.davenonymous.bonsaitrees3.client.TreeModels;
import com.davenonymous.bonsaitrees3.libnonymous.render.MultiModelBlockRenderer;
import com.davenonymous.bonsaitrees3.libnonymous.serialization.MultiblockBlockModel;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;

public class BonsaiPotRenderer
implements BlockEntityRenderer<BonsaiPotBlockEntity> {
    public static final ResourceLocation WATER = new ResourceLocation("minecraft", "block/water_still");

    public BonsaiPotRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BonsaiPotBlockEntity pPotBlock, float pPartialTick, PoseStack poseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (!pPotBlock.hasSapling() || !pPotBlock.hasSoil()) {
            return;
        }
        if (pPotBlock.m_58904_() == null) {
            return;
        }
        SaplingInfo saplingInfo = pPotBlock.getSaplingInfo();
        if (saplingInfo == null) {
            return;
        }
        MultiblockBlockModel multiBlock = TreeModels.get(saplingInfo.m_6423_());
        if (multiBlock == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, (double)0.1f, 0.5);
        float scale = (float)multiBlock.getScaleRatio(true);
        poseStack.m_85841_(scale, scale, scale);
        float maxSize = 0.9f;
        poseStack.m_85841_(maxSize, maxSize, maxSize);
        float progress = (float)pPotBlock.getProgress(pPartialTick);
        poseStack.m_85841_(progress, progress, progress);
        float rotate = (float)pPotBlock.modelRotation * 90.0f;
        poseStack.m_85845_(new Quaternion(Vector3f.f_122225_, rotate, true));
        float translateOffsetX = (float)(multiBlock.width + 1) / 2.0f;
        float translateOffsetY = 0.0f;
        float translateOffsetZ = (float)(multiBlock.depth + 1) / 2.0f;
        poseStack.m_85837_((double)(-translateOffsetX), (double)(-translateOffsetY), (double)(-translateOffsetZ));
        VertexConsumer buffer = pBufferSource.m_6299_(RenderType.m_110466_());
        MultiModelBlockRenderer.renderMultiBlockModel(multiBlock, (BlockAndTintGetter)pPotBlock.m_58904_(), buffer, poseStack, pPackedLight);
        poseStack.m_85849_();
    }
}

