/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.client;

import com.davenonymous.bonsaitrees3.libnonymous.serialization.MultiBlockModelSerializer;
import com.davenonymous.bonsaitrees3.libnonymous.serialization.MultiblockBlockModel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TreeModels {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().registerTypeAdapter(MultiblockBlockModel.class, (Object)new MultiBlockModelSerializer()).create();
    private static HashMap<ResourceLocation, MultiblockBlockModel> treeModels;

    public static void init() {
        Collection resources = Minecraft.m_91087_().m_91098_().m_6540_("models/tree", p -> p.endsWith(".json"));
        ArrayList<MultiblockBlockModel> models = new ArrayList<MultiblockBlockModel>();
        for (ResourceLocation resource : resources) {
            try {
                InputStream is = Minecraft.m_91087_().m_91098_().m_142591_(resource).m_6679_();
                MultiblockBlockModel model = (MultiblockBlockModel)GSON.fromJson(new JsonReader((Reader)new InputStreamReader(is)), MultiblockBlockModel.class);
                if (model != null) {
                    LOGGER.info("Loaded tree model: {}", (Object)model.id);
                    models.add(model);
                    continue;
                }
                LOGGER.warn("Unable to read model from: {}", (Object)resource);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        treeModels = new HashMap();
        for (MultiblockBlockModel model : models) {
            if (treeModels.containsKey(model.id)) {
                LOGGER.warn("Duplicate model for tree: {}.", (Object)model.id);
            }
            treeModels.put(model.id, model);
        }
        LOGGER.info("Found {} tree models.", (Object)models.size());
    }

    @Nullable
    public static MultiblockBlockModel get(ResourceLocation treeId) {
        return treeModels.get(treeId);
    }
}

