/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.compat.jei;

import com.davenonymous.bonsaitrees3.compat.jei.BonsaiUpgradeWrapper;
import com.davenonymous.bonsaitrees3.libnonymous.base.BaseLanguageProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class BonsaiUpgradeCategory
implements IRecipeCategory<BonsaiUpgradeWrapper> {
    public static final ResourceLocation ID = new ResourceLocation("bonsaitrees3", "upgrades");
    private final IDrawableStatic background;
    private final IDrawableStatic slotDrawable;

    public BonsaiUpgradeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(155, 20);
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    public void draw(BonsaiUpgradeWrapper recipe, PoseStack stack, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        String text = I18n.m_118938_((String)BaseLanguageProvider.getTranslatableLanguageKey(recipe.upgradeDescription), (Object[])new Object[0]);
        List split = font.m_92865_().m_92432_(text, 120, Style.f_131099_);
        int yOffset = 0;
        if (split.size() == 1) {
            yOffset = 5;
        } else if (split.size() == 2) {
            yOffset = 1;
        } else if (split.size() == 3) {
            yOffset = -3;
        }
        for (FormattedText line : split) {
            Minecraft.m_91087_().f_91062_.m_92883_(stack, line.getString(), 24.0f, (float)yOffset, 0x404040);
            yOffset += 9;
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends BonsaiUpgradeWrapper> getRecipeClass() {
        return BonsaiUpgradeWrapper.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("jei.bonsaitrees3.upgrades.title");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(BonsaiUpgradeWrapper recipe, IIngredients ingredients) {
        recipe.setIngredients(ingredients);
    }

    public void setRecipe(IRecipeLayout recipeLayout, BonsaiUpgradeWrapper recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 0);
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)recipe);
        recipeLayout.getItemStacks().set(ingredients);
    }
}

