/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.libnonymous.base;

import com.davenonymous.bonsaitrees3.libnonymous.serialization.nbt.NBTFieldSerializationData;
import com.davenonymous.bonsaitrees3.libnonymous.serialization.nbt.NBTFieldUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BaseBlockEntity<T extends BaseBlockEntity>
extends BlockEntity {
    private boolean initialized = false;
    private List<NBTFieldSerializationData> NBTActions = NBTFieldUtils.initSerializableStoreFields(((Object)((Object)this)).getClass());

    public BaseBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public T getSelf(Level level, BlockPos pos) {
        return (T)((Object)((BaseBlockEntity)level.m_7702_(pos)));
    }

    public void loadFromItem(ItemStack stack) {
        if (!stack.m_41782_()) {
            return;
        }
        NBTFieldUtils.readFieldsFromNBT(this.NBTActions, (Object)this, stack.m_41783_(), data -> data.storeWithItem);
        this.m_6596_();
    }

    public void m_187476_(ItemStack stack) {
        CompoundTag compound = this.createItemStackTagCompound();
        stack.m_41751_(compound);
    }

    protected CompoundTag createItemStackTagCompound() {
        return NBTFieldUtils.writeFieldsToNBT(this.NBTActions, (Object)this, new CompoundTag(), data -> data.storeWithItem);
    }

    public void notifyClients() {
        this.notifyClients(true);
    }

    public void notifyClients(boolean all) {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), all ? 3 : 2);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return NBTFieldUtils.writeFieldsToNBT(this.NBTActions, (Object)this, super.m_5995_(), data -> data.sendInUpdatePackage);
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag == null) {
            return;
        }
        NBTFieldUtils.readFieldsFromNBT(this.NBTActions, (Object)this, tag, data -> true);
        this.onDataLoaded();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        NBTFieldUtils.readFieldsFromNBT(this.NBTActions, (Object)this, pkt.m_131708_(), data -> data.sendInUpdatePackage);
        this.onDataLoaded();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        NBTFieldUtils.readFieldsFromNBT(this.NBTActions, (Object)this, compound, data -> true);
        this.onDataLoaded();
    }

    protected void m_183515_(CompoundTag compound) {
        NBTFieldUtils.writeFieldsToNBT(this.NBTActions, (Object)this, compound, data -> true);
    }

    public void onDataLoaded() {
    }

    public void tickBoth() {
    }

    public void tickServer() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        this.tickBoth();
    }

    public void tickClient() {
        this.tickBoth();
    }

    protected void initialize() {
    }

    public IItemHandler getNeighborInventory(Direction side) {
        BlockEntity belowBlockEntity = this.f_58857_.m_7702_(this.m_58899_().m_142300_(side));
        if (belowBlockEntity == null) {
            return null;
        }
        return (IItemHandler)belowBlockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.m_122424_()).orElseGet(null);
    }
}

