/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.libnonymous.gui.framework;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GUIHelper {
    public static void drawStringCentered(PoseStack pPoseStack, String str, Screen screen, float x, float y, int color) {
        Font renderer = screen.getMinecraft().f_91062_;
        float xPos = x - (float)renderer.m_92895_(str) / 2.0f;
        ShaderInstance old = RenderSystem.m_157196_();
        renderer.m_92883_(pPoseStack, str, xPos, y, color);
        RenderSystem.m_157427_(() -> old);
    }

    public static void drawSplitStringCentered(PoseStack pPoseStack, String str, Screen screen, int x, int y, int width, int color) {
        Font renderer = screen.getMinecraft().f_91062_;
        int yOffset = 0;
        for (FormattedText row : renderer.m_92865_().m_92432_(str, width, Style.f_131099_)) {
            GUIHelper.drawStringCentered(pPoseStack, row.getString(), screen, x + width / 2, y + yOffset, color);
            Objects.requireNonNull(renderer);
            yOffset += 9;
        }
    }

    public static void drawColoredRectangle(PoseStack pPoseStack, int x, int y, int width, int height, int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        GUIHelper.drawColoredRectangle(pPoseStack, x, y, width, height, r, g, b, a);
    }

    public static void drawColoredRectangle(PoseStack pPoseStack, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        float zLevel = 0.0f;
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69465_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = pPoseStack.m_85850_().m_85861_();
        builder.m_85982_(matrix, (float)(x + 0), (float)(y + 0), zLevel).m_6122_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, (float)(x + 0), (float)(y + height), zLevel).m_6122_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, (float)(x + width), (float)(y + height), zLevel).m_6122_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, (float)(x + width), (float)(y + 0), zLevel).m_6122_(red, green, blue, alpha).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69482_();
        RenderSystem.m_69493_();
    }

    public static void drawStretchedTexture(PoseStack pPoseStack, int x, int y, int width, int height, int textureX, int textureY, int textureWidth, int textureHeight) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        float zLevel = 0.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = pPoseStack.m_85850_().m_85861_();
        builder.m_85982_(matrix, (float)x, (float)(y + height), zLevel).m_7421_((float)textureX * 0.00390625f, (float)(textureY + textureHeight) * 0.00390625f).m_5752_();
        builder.m_85982_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(textureX + textureWidth) * 0.00390625f, (float)(textureY + textureHeight) * 0.00390625f).m_5752_();
        builder.m_85982_(matrix, (float)(x + width), (float)y, zLevel).m_7421_((float)(textureX + textureWidth) * 0.00390625f, (float)textureY * 0.00390625f).m_5752_();
        builder.m_85982_(matrix, (float)x, (float)y, zLevel).m_7421_((float)textureX * 0.00390625f, (float)textureY * 0.00390625f).m_5752_();
        tesselator.m_85914_();
    }

    public static void drawModalRectWithCustomSizedTexture(PoseStack pPoseStack, int x, int y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = pPoseStack.m_85850_().m_85861_();
        builder.m_85982_(matrix, (float)x, (float)(y + height), 0.0f).m_7421_(u * f, (v + (float)height) * f1).m_5752_();
        builder.m_85982_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_7421_((u + (float)width) * f, (v + (float)height) * f1).m_5752_();
        builder.m_85982_(matrix, (float)(x + width), (float)y, 0.0f).m_7421_((u + (float)width) * f, v * f1).m_5752_();
        builder.m_85982_(matrix, (float)x, (float)y, 0.0f).m_7421_(u * f, v * f1).m_5752_();
        tesselator.m_85914_();
    }

    public static void renderGuiItem(ItemStack pStack, int pX, int pY, boolean blackOut) {
        boolean flag;
        BakedModel pBakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(pStack, (Level)null, (LivingEntity)null, 0);
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)pX, (double)pY, 100.0);
        posestack.m_85837_(8.0, 8.0, 0.0);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        PoseStack posestack1 = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !pBakedmodel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        Minecraft.m_91087_().m_91291_().m_115143_(pStack, ItemTransforms.TransformType.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, blackOut ? 0 : 0xF000F0, OverlayTexture.f_118083_, pBakedmodel);
        multibuffersource$buffersource.m_109911_();
        RenderSystem.m_69482_();
        if (flag) {
            Lighting.m_84931_();
        }
        posestack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static void fillAreaWithIcon(PoseStack pPoseStack, TextureAtlasSprite icon, int x, int y, int width, int height) {
        int xNow;
        int yNow;
        Tesselator t = Tesselator.m_85913_();
        BufferBuilder b = t.m_85915_();
        b.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float zLevel = 0.0f;
        int iconWidth = icon.m_118405_();
        int iconHeight = icon.m_118408_();
        int fullCols = width / iconWidth;
        int fullRows = height / iconHeight;
        float minU = icon.m_118409_();
        float maxU = icon.m_118410_();
        float minV = icon.m_118411_();
        float maxV = icon.m_118412_();
        int excessWidth = width % iconWidth;
        int excessHeight = height % iconHeight;
        float partialMaxU = minU + (maxU - minU) * ((float)excessWidth / (float)iconWidth);
        float partialMaxV = minV + (maxV - minV) * ((float)excessHeight / (float)iconHeight);
        for (int row = 0; row < fullRows; ++row) {
            yNow = y + row * iconHeight;
            for (int col = 0; col < fullCols; ++col) {
                xNow = x + col * iconWidth;
                GUIHelper.drawRect(pPoseStack, xNow, yNow, iconWidth, iconHeight, zLevel, minU, minV, maxU, maxV);
            }
            if (excessWidth == 0) continue;
            xNow = x + fullCols * iconWidth;
            GUIHelper.drawRect(pPoseStack, xNow, yNow, iconWidth, iconHeight, zLevel, minU, minV, maxU, maxV);
        }
        if (excessHeight != 0) {
            for (int col = 0; col < fullCols; ++col) {
                xNow = x + col * iconWidth;
                yNow = y + fullRows * iconHeight;
                GUIHelper.drawRect(pPoseStack, xNow, yNow, iconWidth, excessHeight, zLevel, minU, minV, maxU, partialMaxV);
            }
            if (excessWidth != 0) {
                xNow = x + fullCols * iconWidth;
                yNow = y + fullRows * iconHeight;
                GUIHelper.drawRect(pPoseStack, xNow, yNow, excessWidth, excessHeight, zLevel, minU, minV, partialMaxU, partialMaxV);
            }
        }
        t.m_85914_();
    }

    private static void drawRect(PoseStack pPoseStack, float x, float y, float width, float height, float z, float u, float v, float maxU, float maxV) {
        BufferBuilder b = Tesselator.m_85913_().m_85915_();
    }
}

