/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.libnonymous.gui.framework;

import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.CircularPointedArrayList;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.WidgetSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class WidgetContainer
extends AbstractContainerMenu {
    public static ResourceLocation SLOTGROUP_PLAYER = new ResourceLocation("bonsaitrees3", "player_slots");
    private IItemHandler playerInventory;
    private CircularPointedArrayList<ResourceLocation> slotGroups;
    private Map<ResourceLocation, List<Integer>> slotGroupMap;
    private Map<ResourceLocation, List<ResourceLocation>> allowedSlotGroupQuickMoving;
    private int nextSlotId = 0;

    protected WidgetContainer(@Nullable MenuType<?> type, int id, Inventory inv) {
        super(type, id);
        this.playerInventory = new InvWrapper((Container)inv);
        this.slotGroups = new CircularPointedArrayList();
        this.slotGroupMap = new HashMap<ResourceLocation, List<Integer>>();
        this.allowedSlotGroupQuickMoving = new HashMap<ResourceLocation, List<ResourceLocation>>();
    }

    protected Slot m_38897_(Slot slotIn) {
        if (!(slotIn instanceof WidgetSlot)) {
            throw new RuntimeException("Only WidgetSlots are allowed in a WidgetContainer!");
        }
        ResourceLocation slotGroupId = ((WidgetSlot)slotIn).getGroupId();
        if (!this.slotGroups.contains(slotGroupId)) {
            this.slotGroups.add(slotGroupId);
        }
        if (!this.slotGroupMap.containsKey(slotGroupId)) {
            this.slotGroupMap.put(slotGroupId, new ArrayList());
        }
        this.slotGroupMap.get(slotGroupId).add(this.nextSlotId++);
        return super.m_38897_(slotIn);
    }

    protected void allowSlotGroupMovement(ResourceLocation from, ResourceLocation to, boolean bidirectional) {
        this.allowSlotGroupMovement(from, to);
        if (bidirectional) {
            this.allowSlotGroupMovement(to, from);
        }
    }

    protected void allowSlotGroupMovement(ResourceLocation from, ResourceLocation to) {
        if (!this.allowedSlotGroupQuickMoving.containsKey(from)) {
            this.allowedSlotGroupQuickMoving.put(from, new ArrayList());
        }
        this.allowedSlotGroupQuickMoving.get(from).add(to);
    }

    protected void lockSlot(int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot instanceof WidgetSlot) {
            ((WidgetSlot)slot).setLocked(true);
            this.f_38839_.set(index, (Object)slot);
        }
    }

    protected int addSlotRange(ResourceLocation id, IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new WidgetSlot(id, handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    protected int addSlotBox(ResourceLocation id, IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(id, handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    protected void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(SLOTGROUP_PLAYER, this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(SLOTGROUP_PLAYER, this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    private ArrayList<Integer> getTransferTargetSlots(WidgetSlot pSlot) {
        ItemStack stack = pSlot.m_7993_();
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int groupIndex = 0; groupIndex < this.slotGroups.size(); ++groupIndex) {
            List<ResourceLocation> allowedGroups;
            ResourceLocation targetGroup = this.slotGroups.next();
            if (this.allowedSlotGroupQuickMoving.containsKey(pSlot.getGroupId()) && (allowedGroups = this.allowedSlotGroupQuickMoving.get(pSlot.getGroupId())).size() > 0 && !allowedGroups.contains(targetGroup)) continue;
            List<Integer> slotsForThisGroup = this.slotGroupMap.get(targetGroup);
            for (int slotIndex : slotsForThisGroup) {
                ItemStack existingStack;
                WidgetSlot testSlot = (WidgetSlot)((Object)this.f_38839_.get(slotIndex));
                if (!testSlot.isEnabled() || testSlot.isLocked() || !testSlot.m_5857_(stack) || testSlot.m_6657_() && (!stack.m_41753_() || !(existingStack = testSlot.m_7993_()).m_41753_() || !existingStack.m_150930_(stack.m_41720_()) || existingStack.m_41613_() >= existingStack.m_41741_() || existingStack.m_41613_() >= testSlot.m_6641_() || existingStack.m_41613_() >= testSlot.m_5866_(existingStack) || !stack.areShareTagsEqual(existingStack))) continue;
                result.add(slotIndex);
            }
        }
        return result;
    }

    private int getSlotStackLimit(WidgetSlot slot, ItemStack stack) {
        int limit = Integer.MAX_VALUE;
        limit = Math.min(limit, slot.m_5866_(stack));
        limit = Math.min(limit, slot.m_6641_());
        limit = Math.min(limit, stack.m_41741_());
        return limit;
    }

    private ItemStack insertStackIntoSlot(WidgetSlot slot, ItemStack stack) {
        ItemStack existingStack = slot.m_7993_();
        int fitSize = this.getSlotStackLimit(slot, stack);
        int remainingSpace = fitSize - existingStack.m_41613_();
        int toAddSize = stack.m_41613_();
        int remaining = Math.max(0, toAddSize - remainingSpace);
        int inserted = toAddSize - remaining;
        ItemStack toInsert = stack.m_41777_();
        toInsert.m_41764_(inserted + existingStack.m_41613_());
        slot.m_5852_(toInsert);
        ItemStack remainingStack = stack.m_41777_();
        remainingStack.m_41764_(remaining);
        return remainingStack;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        WidgetSlot targetSlot;
        int targetSlotId;
        Slot uncastSlot = (Slot)this.f_38839_.get(index);
        if (uncastSlot == null || !uncastSlot.m_6657_() || !(uncastSlot instanceof WidgetSlot)) {
            return ItemStack.f_41583_;
        }
        WidgetSlot slot = (WidgetSlot)uncastSlot;
        ItemStack stackToMove = uncastSlot.m_7993_().m_41777_();
        if (stackToMove.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.slotGroups.setPointerTo(slot.getGroupId());
        ArrayList<Integer> availableSlotsInOrderOfPriority = this.getTransferTargetSlots(slot);
        Iterator iterator = availableSlotsInOrderOfPriority.iterator();
        while (iterator.hasNext() && ((targetSlotId = ((Integer)iterator.next()).intValue()) == index || !(stackToMove = this.insertStackIntoSlot(targetSlot = (WidgetSlot)((Object)this.f_38839_.get(targetSlotId)), stackToMove)).m_41619_())) {
        }
        slot.m_5852_(stackToMove);
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player pPlayer) {
        return true;
    }
}

