/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.libnonymous.gui.framework;

import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.GUI;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.WidgetContainer;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.WidgetSlot;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.CharTypedEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.GuiDataUpdatedEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.KeyPressedEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.KeyReleasedEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.MouseMoveEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.MouseReleasedEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.MouseScrollEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.UpdateScreenEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.WidgetEventResult;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public abstract class WidgetContainerScreen<T extends WidgetContainer>
extends AbstractContainerScreen<T> {
    protected GUI gui;
    private int previousMouseX = Integer.MAX_VALUE;
    private int previousMouseY = Integer.MAX_VALUE;
    public boolean dataUpdated = false;

    public WidgetContainerScreen(T container, Inventory inv, Component name) {
        super(container, inv, name);
        this.gui = this.createGUI();
        this.gui.setVisible(true);
    }

    protected abstract GUI createGUI();

    protected void m_181908_() {
        super.m_181908_();
        this.gui.fireEvent(new UpdateScreenEvent());
        this.resetMousePositions();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.gui.fireEvent(new MouseClickEvent(mouseX, mouseY, mouseButton)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.m_6375_(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        Slot slot = this.getSlotUnderMouse();
        if (this.gui.fireEvent(new MouseReleasedEvent(mouseX, mouseY, mouseButton)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.m_6348_(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.gui.fireEvent(new KeyReleasedEvent(keyCode, scanCode, modifiers)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.m_7920_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean m_5534_(char chr, int code) {
        if (this.gui.fireEvent(new CharTypedEvent(chr, code)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.m_5534_(chr, code);
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.gui.fireEvent(new KeyPressedEvent(keyCode, scanCode, modifiers)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        if (this.gui.fireEvent(new MouseScrollEvent(mouseX, mouseY, scrollAmount)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.m_6050_(mouseX, mouseY, scrollAmount);
        }
        return false;
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        int minY = this.f_96544_;
        for (Slot slot : ((WidgetContainer)this.f_97732_).f_38839_) {
            WidgetSlot ws;
            if (!(slot instanceof WidgetSlot) || (ws = (WidgetSlot)slot).getGroupId() != WidgetContainer.SLOTGROUP_PLAYER || ws.f_40221_ >= minY) continue;
            minY = ws.f_40221_;
        }
        Objects.requireNonNull(this.f_96547_);
        this.f_97731_ = minY - (9 + 2);
        this.f_96547_.m_92889_(pPoseStack, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
        this.f_96547_.m_92889_(pPoseStack, this.f_96539_, (float)this.f_97728_, 7.0f, 0x404040);
        pPoseStack.m_85836_();
        pPoseStack.m_85837_((double)(-this.getGuiLeft()), (double)(-this.getGuiTop() + 18), 0.0);
        this.gui.drawTooltips(pPoseStack, (Screen)this, pMouseX, pMouseY);
        this.m_7025_(pPoseStack, pMouseX, pMouseY);
        pPoseStack.m_85849_();
    }

    public void m_6305_(PoseStack pPoseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.dataUpdated) {
            this.dataUpdated = false;
            this.gui.fireEvent(new GuiDataUpdatedEvent());
        }
        if (mouseX != this.previousMouseX || mouseY != this.previousMouseY) {
            this.gui.fireEvent(new MouseMoveEvent(mouseX, mouseY));
            this.previousMouseX = mouseX;
            this.previousMouseY = mouseY;
        }
        super.m_6305_(pPoseStack, mouseX, mouseY, partialTicks);
    }

    protected void m_7286_(PoseStack pPoseStack, float pPartialTick, int pMouseX, int pMouseY) {
        this.m_7333_(pPoseStack);
        this.gui.drawGUI(pPoseStack, (Screen)this);
        if (this.f_97732_ != null && ((WidgetContainer)this.f_97732_).f_38839_ != null) {
            for (Slot slot : ((WidgetContainer)this.f_97732_).f_38839_) {
                WidgetSlot widgetSlot;
                if (!(slot instanceof WidgetSlot) || !(widgetSlot = (WidgetSlot)slot).isEnabled()) continue;
                this.gui.drawSlot(pPoseStack, (Screen)this, slot, this.f_97735_, this.f_97736_);
            }
        }
    }

    protected void resetMousePositions() {
        this.previousMouseX = Integer.MIN_VALUE;
        this.previousMouseY = Integer.MIN_VALUE;
    }

    public void fireDataUpdateEvent() {
        this.dataUpdated = true;
    }
}

