/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.libnonymous.gui.framework.widgets;

import com.davenonymous.bonsaitrees3.libnonymous.base.BaseLanguageProvider;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.GUI;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.FocusChangedEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.IEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.IWidgetListener;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.MouseEnterEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.MouseExitEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.VisibilityChangedEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.bonsaitrees3.libnonymous.helper.Translatable;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;

public class Widget {
    public int x;
    public int y;
    public int width;
    public int height;
    boolean enabled = true;
    boolean focused = false;
    boolean visible = true;
    boolean hovered = false;
    Widget parent;
    List<Component> tooltipLines = new ArrayList<Component>();
    Map<Class<? extends IEvent>, List<IWidgetListener>> eventListeners = new HashMap<Class<? extends IEvent>, List<IWidgetListener>>();
    List<IWidgetListener> anyEventListener = new ArrayList<IWidgetListener>();

    public Widget() {
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            widget.getRootWidget().fireEvent(new FocusChangedEvent());
            if (widget.focusable()) {
                widget.focused = true;
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(FocusChangedEvent.class, (event, widget) -> {
            widget.focused = false;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseEnterEvent.class, (event, widget) -> {
            widget.hovered = true;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseExitEvent.class, (event, widget) -> {
            widget.hovered = false;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setDimensions(int x, int y, int width, int height) {
        this.setSize(width, height);
        this.setPosition(x, y);
    }

    public boolean hasToolTip() {
        return this.tooltipLines != null && this.tooltipLines.size() > 0;
    }

    public List<String> getTooltipAsString() {
        return this.getTooltip().stream().map(Component::getString).collect(Collectors.toList());
    }

    public List<FormattedCharSequence> getTooltipAsFormattedCharSequence() {
        return this.getTooltip().stream().map(component -> FormattedCharSequence.m_13714_((String)component.getString(), (Style)component.m_7383_())).collect(Collectors.toList());
    }

    public List<Component> getTooltip() {
        if (this.tooltipLines == null) {
            return Collections.emptyList();
        }
        return this.tooltipLines;
    }

    public Widget setTooltipLines(List<Component> tooltipLines) {
        this.tooltipLines = tooltipLines;
        return this;
    }

    public Widget setTooltipLines(Translatable ... tooltipLines) {
        this.tooltipLines = Arrays.stream(tooltipLines).map(translatable -> new TextComponent(I18n.m_118938_((String)BaseLanguageProvider.getTranslatableLanguageKey(translatable), (Object[])new Object[0]))).collect(Collectors.toList());
        return this;
    }

    public Widget setTooltipLines(Component ... tooltipLines) {
        this.tooltipLines = new ArrayList<Component>();
        for (Component line : tooltipLines) {
            this.tooltipLines.add(line);
        }
        return this;
    }

    public Widget addTooltipLine(Component ... tooltipLines) {
        for (Component line : tooltipLines) {
            this.tooltipLines.add(line);
        }
        return this;
    }

    public Widget addTooltipLine(List<Component> strings) {
        this.tooltipLines.addAll(strings);
        return this;
    }

    public boolean areAllParentsVisible() {
        return this.isVisible() && (this.parent == null || this.parent.areAllParentsVisible());
    }

    public boolean focusable() {
        return true;
    }

    public static int computeGuiScale(Minecraft mc) {
        int scaleFactor = 1;
        int k = mc.f_91066_.f_92072_;
        if (k == 0) {
            k = 1000;
        }
        while (scaleFactor < k && mc.m_91268_().m_85441_() / (scaleFactor + 1) >= 320 && mc.m_91268_().m_85442_() / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        return scaleFactor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[?]";
    }

    public boolean isPosInside(double x, double y) {
        boolean isInsideX = (double)this.getActualX() <= x && x < (double)(this.getActualX() + this.width);
        boolean isInsideY = (double)this.getActualY() <= y && y < (double)(this.getActualY() + this.height);
        return isInsideX && isInsideY;
    }

    public int getActualX() {
        int result = this.x;
        Widget parent = this.parent;
        while (parent != null) {
            result += parent.x;
            parent = parent.parent;
        }
        return result;
    }

    public int getActualY() {
        int result = this.y;
        Widget parent = this.parent;
        while (parent != null) {
            result += parent.y;
            parent = parent.parent;
        }
        return result;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.visible;
        this.visible = visible;
        this.fireEvent(new VisibilityChangedEvent(oldVisible, visible));
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDisabled() {
        this.enabled = false;
    }

    public void setParent(Widget parent) {
        this.parent = parent;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public Widget getRootWidget() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRootWidget();
    }

    public GUI getGUI() {
        Widget root = this.getRootWidget();
        if (root instanceof GUI) {
            return (GUI)root;
        }
        return null;
    }

    public void shiftAndDraw(PoseStack pPoseStack, Screen screen) {
        this.drawBeforeShift(pPoseStack, screen);
        pPoseStack.m_85836_();
        pPoseStack.m_85837_((double)this.x, (double)this.y, 0.0);
        this.draw(pPoseStack, screen);
        pPoseStack.m_85849_();
    }

    public void drawBeforeShift(PoseStack pPoseStack, Screen screen) {
    }

    public void draw(PoseStack pPoseStack, Screen screen) {
    }

    public <T extends IEvent> void addListener(Class<T> eventClass, IWidgetListener<? super T> listener) {
        if (!this.eventListeners.containsKey(eventClass)) {
            this.eventListeners.put(eventClass, new ArrayList());
        }
        this.eventListeners.get(eventClass).add(listener);
    }

    public void addAnyListener(IWidgetListener listener) {
        this.anyEventListener.add(listener);
    }

    public <T extends IEvent> void addChildListener(Class<T> eventClass, Widget receiveEventsFromWidget) {
        Widget self = this;
        receiveEventsFromWidget.addListener(eventClass, (event, widget) -> self.fireEvent(event));
    }

    public WidgetEventResult fireEvent(IEvent event) {
        WidgetEventResult immediateResult;
        for (IWidgetListener listener : this.anyEventListener) {
            immediateResult = listener.call(event, this);
            if (immediateResult != WidgetEventResult.HANDLED) continue;
            return WidgetEventResult.HANDLED;
        }
        if (!this.eventListeners.containsKey(event.getClass())) {
            return WidgetEventResult.CONTINUE_PROCESSING;
        }
        for (IWidgetListener listener : this.eventListeners.get(event.getClass())) {
            immediateResult = listener.call(event, this);
            if (immediateResult != WidgetEventResult.HANDLED) continue;
            return WidgetEventResult.HANDLED;
        }
        return WidgetEventResult.CONTINUE_PROCESSING;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

