/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.libnonymous.gui.framework.widgets;

import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.widgets.Widget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.client.gui.screens.Screen;

public class WidgetColorDisplay
extends Widget {
    private Color colorA;
    private Color colorB;
    private boolean horizontal;

    public WidgetColorDisplay(Color color) {
        this.colorA = color;
        this.colorB = color;
        this.horizontal = false;
    }

    public WidgetColorDisplay(Color primary, Color secondary, boolean horizontal) {
        this.colorA = primary;
        this.colorB = secondary;
        this.horizontal = horizontal;
    }

    public Color getColor() {
        return this.colorA;
    }

    public Color getSecondaryColor() {
        return this.colorB;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public WidgetColorDisplay setColor(Color color) {
        this.colorA = color;
        return this;
    }

    public WidgetColorDisplay setSecondaryColor(Color color) {
        this.colorB = color;
        return this;
    }

    public WidgetColorDisplay setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
        return this;
    }

    @Override
    public void draw(PoseStack pPoseStack, Screen screen) {
        if (this.isHorizontal()) {
            WidgetColorDisplay.drawHorizontalGradientRect(pPoseStack, 0, 0, this.width, this.height, this.colorA, this.colorB);
        } else {
            WidgetColorDisplay.drawVerticalGradientRect(pPoseStack, 0, 0, this.width, this.height, this.colorA, this.colorB);
        }
    }

    private static void drawHorizontalGradientRect(PoseStack pPoseStack, int x1, int y1, int x2, int y2, Color primary, Color secondary) {
        float zLevel = 0.0f;
        float[] pColors = primary.getRGBColorComponents(null);
        float pA = 1.0f;
        float pR = pColors[0];
        float pG = pColors[1];
        float pB = pColors[2];
        float[] sColors = secondary.getRGBColorComponents(null);
        float sA = 1.0f;
        float sR = sColors[0];
        float sG = sColors[1];
        float sB = sColors[2];
    }

    private static void drawVerticalGradientRect(PoseStack pPoseStack, int x1, int y1, int x2, int y2, Color primary, Color secondary) {
        float zLevel = 0.0f;
        float[] pColors = primary.getRGBColorComponents(null);
        float pA = 1.0f;
        float pR = pColors[0];
        float pG = pColors[1];
        float pB = pColors[2];
        float[] sColors = secondary.getRGBColorComponents(null);
        float sA = 1.0f;
        float sR = sColors[0];
        float sG = sColors[1];
        float sB = sColors[2];
    }
}

