/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.libnonymous.gui.framework.widgets;

import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.MouseEnterEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.MouseExitEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.MouseMoveEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.ValueChangedEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.VisibilityChangedEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.widgets.IValueProvider;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.widgets.Widget;
import com.davenonymous.bonsaitrees3.network.Networking;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.inventory.Slot;

public class WidgetPanel
extends Widget {
    List<Widget> children = new LinkedList<Widget>();
    List<Widget> previouslyHovered = new ArrayList<Widget>();

    public WidgetPanel() {
        this.addListener(MouseMoveEvent.class, (event, widget) -> {
            for (Widget child : this.children) {
                MouseMoveEvent shifted = new MouseMoveEvent(event.x, event.y);
                child.fireEvent(shifted);
                if (!child.isPosInside(event.x, event.y)) {
                    if (!this.previouslyHovered.contains(child)) continue;
                    child.fireEvent(new MouseExitEvent());
                    this.previouslyHovered.remove(child);
                    continue;
                }
                if (this.previouslyHovered.contains(child)) continue;
                child.fireEvent(new MouseEnterEvent());
                this.previouslyHovered.add(child);
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(VisibilityChangedEvent.class, (event, widget1) -> {
            if (Minecraft.m_91087_().f_91074_ != null && this.getGUI().getContainer() != null) {
                Networking.sendEnabledSlotsMessage((List<Slot>)this.getGUI().getContainer().f_38839_);
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            double innerX = event.x - (double)widget.getActualX();
            double innerY = event.y - (double)widget.getActualY();
            for (Widget child : this.children) {
                if (!child.visible || !child.isPosInside(event.x, event.y) || child.fireEvent(new MouseClickEvent(event.x, event.y, event.button)) != WidgetEventResult.HANDLED) continue;
                return WidgetEventResult.HANDLED;
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        HashSet eventsToIgnore = Sets.newHashSet((Object[])new Class[]{MouseClickEvent.class, MouseMoveEvent.class, MouseEnterEvent.class, MouseExitEvent.class, ValueChangedEvent.class});
        this.addAnyListener((event, widget) -> {
            if (eventsToIgnore.contains(event.getClass())) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            for (Widget child : this.children) {
                WidgetEventResult immediateResult = child.fireEvent(event);
                if (immediateResult != WidgetEventResult.HANDLED) continue;
                return WidgetEventResult.HANDLED;
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    @Override
    public boolean focusable() {
        return false;
    }

    public void clear() {
        this.children.clear();
    }

    public void add(Widget widget) {
        this.children.add(widget);
        widget.setParent(this);
    }

    public void remove(Widget widget) {
        this.children.remove(widget);
    }

    public List<Widget> getHoveredWidgets() {
        ArrayList<Widget> result = new ArrayList<Widget>();
        this.getHoveredWidgets(result);
        return result;
    }

    private void getHoveredWidgets(List<Widget> result) {
        for (Widget widget : this.previouslyHovered) {
            if (widget instanceof WidgetPanel) {
                ((WidgetPanel)widget).getHoveredWidgets(result);
                continue;
            }
            result.add(widget);
        }
    }

    public Widget getHoveredWidget(int mouseX, int mouseY) {
        for (Widget child : this.children) {
            if (!child.visible || !child.isPosInside(mouseX, mouseY)) continue;
            Widget maybeResult = null;
            if (child instanceof WidgetPanel) {
                maybeResult = ((WidgetPanel)child).getHoveredWidget(mouseX, mouseY);
            }
            if (maybeResult != null && maybeResult.hasToolTip()) {
                return maybeResult;
            }
            return child;
        }
        return null;
    }

    @Override
    public void draw(PoseStack pPoseStack, Screen screen) {
        for (Widget child : this.children) {
            if (!child.visible) continue;
            child.shiftAndDraw(pPoseStack, screen);
        }
    }

    protected void findValueWidgets(WidgetPanel panel) {
        for (Widget child : panel.children) {
            IValueProvider provider;
            if (child instanceof WidgetPanel && !(child instanceof IValueProvider)) {
                this.findValueWidgets((WidgetPanel)child);
            }
            if (!(child instanceof IValueProvider) || (provider = (IValueProvider)((Object)child)).getId() == null) continue;
            this.getGUI().registerValueWidget(provider.getId(), provider);
        }
    }

    public void adjustSizeToContent() {
        int smallestY = Integer.MAX_VALUE;
        int smallestX = Integer.MAX_VALUE;
        int largestY = Integer.MIN_VALUE;
        int largestX = Integer.MIN_VALUE;
        for (Widget child : this.children) {
            smallestX = Math.min(child.x, smallestX);
            smallestY = Math.min(child.y, smallestY);
            largestX = Math.max(child.x + child.width, largestX);
            largestY = Math.max(child.y + child.height, largestY);
        }
        largestX -= smallestX;
        largestY -= smallestY;
        for (Widget child : this.children) {
            child.setX(child.x - smallestX);
            child.setY(child.y - smallestY);
        }
        this.setSize(largestX, largestY);
    }
}

