/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.libnonymous.gui.framework.widgets;

import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.TabChangedEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.widgets.Widget;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.widgets.WidgetPanel;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class WidgetTabsPanel
extends WidgetPanel {
    private List<WidgetPanel> pages = new ArrayList<WidgetPanel>();
    private Map<WidgetPanel, ItemStack> pageStacks = new HashMap<WidgetPanel, ItemStack>();
    private Map<WidgetPanel, List<Component>> pageTooltips = new HashMap<WidgetPanel, List<Component>>();
    private TabDockEdge edge = TabDockEdge.WEST;
    private WidgetPanel activePanel = null;

    public WidgetTabsPanel setEdge(TabDockEdge edge) {
        this.edge = edge;
        return this;
    }

    public void addPage(WidgetPanel panel, ItemStack buttonStack) {
        this.addPage(panel, buttonStack, null);
    }

    public void addPage(WidgetPanel panel, ItemStack buttonStack, List<Component> tooltip) {
        panel.setWidth(this.width);
        panel.setHeight(this.height);
        this.pages.add(panel);
        this.pageStacks.put(panel, buttonStack);
        if (this.activePanel == null) {
            this.activePanel = panel;
            this.activePanel.setVisible(true);
        } else {
            panel.setVisible(false);
        }
        if (tooltip != null) {
            this.pageTooltips.put(panel, tooltip);
        }
        this.add(panel);
    }

    public void setActivePage(int page) {
        if (page < 0 || page >= this.pages.size()) {
            return;
        }
        this.activePanel.setVisible(false);
        this.pages.get(page).setVisible(true);
        WidgetPanel tmpOld = this.activePanel;
        this.activePanel = this.pages.get(page);
        this.fireEvent(new TabChangedEvent(tmpOld, this.pages.get(page)));
    }

    public WidgetPanel getButtonsPanel() {
        WidgetPanel result = new WidgetPanel();
        int y = 0;
        int x = this.edge == TabDockEdge.NORTH ? 4 : 0;
        for (WidgetPanel page : this.pages) {
            WidgetTabsButton button = new WidgetTabsButton(this, page, this.pageStacks.get(page), this.edge);
            button.setPosition(x, y);
            switch (this.edge) {
                default: {
                    button.setSize(32, 28);
                    y += 28;
                    break;
                }
                case NORTH: {
                    button.setSize(31, 32);
                    x += 31;
                }
            }
            result.add(button);
            if (!this.pageTooltips.containsKey(page)) continue;
            button.addTooltipLine(this.pageTooltips.get(page));
        }
        return result;
    }

    public static enum TabDockEdge {
        WEST,
        NORTH;

    }

    private static class WidgetTabsButton
    extends Widget {
        WidgetTabsPanel parent;
        WidgetPanel page;
        ItemStack pageStack;
        TabDockEdge edge;

        public WidgetTabsButton(WidgetTabsPanel parent, WidgetPanel page, ItemStack pageStack, TabDockEdge edge) {
            this.parent = parent;
            this.page = page;
            this.pageStack = pageStack;
            this.edge = edge;
            this.addListener(MouseClickEvent.class, (event, widget) -> {
                this.setActive(true);
                return WidgetEventResult.HANDLED;
            });
        }

        public void setActive(boolean fireEvent) {
            this.parent.activePanel.setVisible(false);
            this.page.setVisible(true);
            WidgetPanel tmpOld = this.parent.activePanel;
            this.parent.activePanel = this.page;
            if (fireEvent) {
                this.parent.fireEvent(new TabChangedEvent(tmpOld, this.page));
            }
        }

        private boolean isActive() {
            return this.parent.activePanel == this.page;
        }

        private boolean isFirst() {
            return this.parent.pages.indexOf(this.page) == 0;
        }

        @Override
        public void draw(PoseStack pPoseStack, Screen screen) {
        }
    }
}

