/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.libnonymous.gui.framework.widgets;

import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.CircularPointedArrayList;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.ValueChangedEvent;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.bonsaitrees3.libnonymous.gui.framework.widgets.Widget;
import java.util.Collection;

public class WidgetWithChoiceValue<T>
extends Widget {
    CircularPointedArrayList<T> choices = new CircularPointedArrayList();

    public T getValue() {
        return this.choices.getPointedElement();
    }

    public void setValue(T choice) {
        this.setValue(choice, true);
    }

    public void setValue(T choice, boolean fireEvent) {
        T oldValue = this.choices.getPointedElement();
        this.choices.setPointerTo(choice);
        if (fireEvent) {
            this.fireEvent(new ValueChangedEvent<T>(oldValue, choice));
        }
    }

    public void addChoice(T ... newChoices) {
        for (T newChoice : newChoices) {
            this.choices.add(newChoice);
        }
    }

    public void addChoiceFromArray(T[] newChoices) {
        for (T newChoice : newChoices) {
            this.choices.add(newChoice);
        }
    }

    public void addChoice(Collection<T> newChoices) {
        this.choices.addAll(newChoices);
    }

    public void next() {
        T oldValue = this.choices.getPointedElement();
        T newValue = this.choices.next();
        this.fireEvent(new ValueChangedEvent<T>(oldValue, newValue));
    }

    public void prev() {
        T oldValue = this.choices.getPointedElement();
        T newValue = this.choices.prev();
        this.fireEvent(new ValueChangedEvent<T>(oldValue, newValue));
    }

    public void addClickListener() {
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            if (event.isLeftClick()) {
                ((WidgetWithChoiceValue)widget).next();
            } else {
                ((WidgetWithChoiceValue)widget).prev();
            }
            return WidgetEventResult.HANDLED;
        });
    }
}

