/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.libnonymous.helper;

import com.davenonymous.bonsaitrees3.libnonymous.base.RecipeData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class BaseRecipeHelper<T extends RecipeData> {
    RecipeType<T> recipeType;

    public BaseRecipeHelper(RecipeType<T> type) {
        this.recipeType = type;
    }

    public boolean hasRecipes(RecipeManager manager) {
        Map<ResourceLocation, T> recipes = this.getRecipes(manager);
        return recipes != null && recipes.size() > 0;
    }

    public int getRecipeCount(RecipeManager manager) {
        Map<ResourceLocation, T> recipes = this.getRecipes(manager);
        return recipes != null ? recipes.size() : 0;
    }

    public T getRecipe(RecipeManager manager, ResourceLocation id) {
        Map<ResourceLocation, T> recipes = this.getRecipes(manager);
        if (recipes == null) {
            return null;
        }
        return (T)((RecipeData)recipes.getOrDefault(id, null));
    }

    public Stream<T> getRecipeStream(RecipeManager manager) {
        return this.getRecipes(manager).values().stream().map(r -> r);
    }

    public Map<ResourceLocation, T> getRecipes(RecipeManager manager) {
        HashMap<ResourceLocation, RecipeData> result = new HashMap<ResourceLocation, RecipeData>();
        List foo = manager.m_44013_(this.recipeType);
        for (RecipeData t : foo) {
            result.put(t.m_6423_(), t);
        }
        return result;
    }

    public List<T> getRecipesList(RecipeManager manager) {
        return this.getRecipeStream(manager).collect(Collectors.toList());
    }

    public T getRandomRecipe(RecipeManager manager, Random rand) {
        Map<ResourceLocation, T> recipes = this.getRecipes(manager);
        if (recipes == null || recipes.size() == 0) {
            return null;
        }
        Set<ResourceLocation> ids = recipes.keySet();
        ResourceLocation randomId = (ResourceLocation)ids.toArray()[rand.nextInt(ids.size())];
        return (T)((RecipeData)recipes.get(randomId));
    }
}

