/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.libnonymous.render;

import com.davenonymous.bonsaitrees3.client.BonsaiPotModelLoader;
import com.davenonymous.bonsaitrees3.libnonymous.render.TintedBakedQuad;
import com.davenonymous.bonsaitrees3.libnonymous.serialization.MultiblockBlockModel;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockBakedModel
implements IDynamicBakedModel {
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final MultiblockBlockModel model;
    private final ItemOverrides overrides;
    private final ItemTransforms itemTransforms;
    private final List<BakedQuad> cache = new ArrayList<BakedQuad>();
    private static Map<MultiblockBlockModel, MultiblockBakedModel> bakeCache = new HashMap<MultiblockBlockModel, MultiblockBakedModel>();

    public static MultiblockBakedModel of(MultiblockBlockModel model) {
        if (!bakeCache.containsKey(model)) {
            bakeCache.put(model, new MultiblockBakedModel(model));
        }
        return bakeCache.get(model);
    }

    private MultiblockBakedModel(MultiblockBlockModel model) {
        this.spriteGetter = material -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(material.m_119193_());
        this.model = model;
        this.overrides = ItemOverrides.f_111734_;
        this.itemTransforms = ItemTransforms.f_111786_;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState inputBlockState, @Nullable Direction pSide, @NotNull Random rand, @NotNull IModelData extraData) {
        RenderType layer = MinecraftForgeClient.getRenderType();
        if (pSide != null || layer != null && !layer.equals(RenderType.m_110451_())) {
            return Collections.emptyList();
        }
        if (this.cache.isEmpty()) {
            BlockModelShaper shaper = Minecraft.m_91087_().m_91289_().m_110907_();
            for (BlockPos pos : this.model.getRelevantPositions()) {
                BlockState state = this.model.blocks.get(pos);
                BakedModel blockModel = shaper.m_110893_(state);
                ArrayList<Direction> sides = new ArrayList<Direction>(List.of(Direction.values()));
                sides.add(null);
                for (Direction side : sides) {
                    List modelQuads = blockModel.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
                    Transformation translate = new Transformation(Matrix4f.m_27653_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_()));
                    QuadTransformer quadTransformer = new QuadTransformer(translate);
                    List transformedQuads = quadTransformer.processMany(modelQuads);
                    for (BakedQuad quad : transformedQuads) {
                        this.cache.add(TintedBakedQuad.of(quad, state, pos));
                    }
                }
            }
        }
        return this.cache;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.spriteGetter.apply(BonsaiPotModelLoader.BONSAIPOT_BRICKS_MATERIAL);
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public ItemTransforms m_7442_() {
        return this.itemTransforms;
    }
}

