/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.libnonymous.render;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class QuadBaker {
    private static void putVertex(BakedQuadBuilder builder, Vector3f normal, Vector4f vector, float u, float v, TextureAtlasSprite sprite, float r, float g, float b, float alpha) {
        ImmutableList elements = builder.getVertexFormat().m_86023_().asList();
        block6: for (int j = 0; j < elements.size(); ++j) {
            VertexFormatElement e = (VertexFormatElement)elements.get(j);
            switch (e.m_86048_()) {
                case POSITION: {
                    builder.put(j, new float[]{vector.m_123601_(), vector.m_123615_(), vector.m_123616_(), 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(j, new float[]{r, g, b, alpha});
                    continue block6;
                }
                case UV: {
                    QuadBaker.putVertexUV(builder, u, v, sprite, j, e);
                    continue block6;
                }
                case NORMAL: {
                    builder.put(j, new float[]{normal.m_122239_(), normal.m_122260_(), normal.m_122269_()});
                    continue block6;
                }
                default: {
                    builder.put(j, new float[0]);
                }
            }
        }
    }

    private static void putVertexUV(BakedQuadBuilder builder, float u, float v, TextureAtlasSprite sprite, int j, VertexFormatElement e) {
        switch (e.m_86049_()) {
            case 0: {
                builder.put(j, new float[]{sprite.m_118367_((double)u), sprite.m_118393_((double)v)});
                break;
            }
            case 2: {
                builder.put(j, new float[]{0.0f, 0.0f});
                break;
            }
            default: {
                builder.put(j, new float[0]);
            }
        }
    }

    public static BakedQuad createQuad(Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, Transformation rotation, TextureAtlasSprite sprite, float r, float g, float b, float alpha) {
        Vector3f normal = v3.m_122281_();
        normal.m_122267_(v2);
        Vector3f temp = v1.m_122281_();
        temp.m_122267_(v2);
        normal.m_122279_(temp);
        normal.m_122278_();
        int tw = sprite.m_118405_();
        int th = sprite.m_118408_();
        rotation = rotation.blockCenterToCorner();
        rotation.transformNormal(normal);
        Vector4f vv1 = new Vector4f(v1);
        rotation.transformPosition(vv1);
        Vector4f vv2 = new Vector4f(v2);
        rotation.transformPosition(vv2);
        Vector4f vv3 = new Vector4f(v3);
        rotation.transformPosition(vv3);
        Vector4f vv4 = new Vector4f(v4);
        rotation.transformPosition(vv4);
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.m_122372_((float)normal.m_122239_(), (float)normal.m_122260_(), (float)normal.m_122269_()));
        QuadBaker.putVertex(builder, normal, vv1, 0.0f, 0.0f, sprite, r, g, b, alpha);
        QuadBaker.putVertex(builder, normal, vv2, 0.0f, th, sprite, r, g, b, alpha);
        QuadBaker.putVertex(builder, normal, vv3, tw, th, sprite, r, g, b, alpha);
        QuadBaker.putVertex(builder, normal, vv4, tw, 0.0f, sprite, r, g, b, alpha);
        return builder.build();
    }

    public static Vector3f v(float x, float y, float z) {
        return new Vector3f(x, y, z);
    }
}

