/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.libnonymous.serialization;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldUtils {
    private static Map<Class, List<Field>> lookupCache = new HashMap<Class, List<Field>>();

    public static List<Field> getAllDeclaredFields(Class clz) {
        if (!lookupCache.containsKey(clz)) {
            List<Field> fields = FieldUtils.getAllDeclaredFields(new ArrayList<Field>(), clz);
            fields.sort(Comparator.comparing(o -> o.getClass().getName()));
            lookupCache.put(clz, fields);
        }
        return lookupCache.get(clz);
    }

    private static List<Field> getAllDeclaredFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            FieldUtils.getAllDeclaredFields(fields, type.getSuperclass());
        }
        return fields;
    }
}

