/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.libnonymous.serialization.nbt;

import com.davenonymous.bonsaitrees3.libnonymous.helper.BlockStateSerializationHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTFieldHandlers {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Class<?>, Pair<NbtReader, NbtWriter>> nbtHandlers = new HashMap();

    public static <T> void addNBTHandler(Class<T> type, NbtReader<T> reader, NbtWriter<T> writer) {
        nbtHandlers.put(type, (Pair<NbtReader, NbtWriter>)Pair.of(reader, writer));
    }

    public static boolean hasNBTHandler(Class clz) {
        if (nbtHandlers.containsKey(clz)) {
            return true;
        }
        for (Class<?> iface : clz.getInterfaces()) {
            if (!nbtHandlers.containsKey(iface)) continue;
            return true;
        }
        Class superClass = clz.getSuperclass();
        if (superClass == null) {
            return false;
        }
        return NBTFieldHandlers.hasNBTHandler(superClass);
    }

    public static Pair<NbtReader, NbtWriter> getNBTHandler(Class clz) {
        if (nbtHandlers.containsKey(clz)) {
            return nbtHandlers.get(clz);
        }
        for (Class<?> iface : clz.getInterfaces()) {
            if (!nbtHandlers.containsKey(iface)) continue;
            return nbtHandlers.get(iface);
        }
        Class superClass = clz.getSuperclass();
        if (superClass == null) {
            return null;
        }
        return NBTFieldHandlers.getNBTHandler(superClass);
    }

    static {
        NBTFieldHandlers.addNBTHandler(boolean[].class, (key, tag, original) -> {
            ListTag listNBT = tag.m_128437_(key, 2);
            boolean[] result = new boolean[listNBT.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = listNBT.m_128757_(i) == 1;
            }
            return null;
        }, (key, booleans, tag) -> {
            ListTag listNBT = new ListTag();
            for (boolean b : booleans) {
                listNBT.add((Object)ShortTag.m_129258_((short)(b ? (short)1 : (short)0)));
            }
            tag.m_128365_(key, (Tag)listNBT);
        });
        NBTFieldHandlers.addNBTHandler(Boolean.TYPE, (key, tag, original) -> tag.m_128471_(key), (key, aBoolean, tag) -> tag.m_128379_(key, aBoolean.booleanValue()));
        NBTFieldHandlers.addNBTHandler(Boolean.class, (key, tag, original) -> tag.m_128471_(key), (key, aBoolean, tag) -> tag.m_128379_(key, aBoolean.booleanValue()));
        NBTFieldHandlers.addNBTHandler(Integer.TYPE, (key, tag, original) -> tag.m_128451_(key), (key, val, tag) -> tag.m_128405_(key, val.intValue()));
        NBTFieldHandlers.addNBTHandler(Integer.class, (key, tag, original) -> tag.m_128451_(key), (key, integer, tag) -> tag.m_128405_(key, integer.intValue()));
        NBTFieldHandlers.addNBTHandler(Float.TYPE, (key, tag, original) -> Float.valueOf(tag.m_128457_(key)), (key, val, tag) -> tag.m_128350_(key, val.floatValue()));
        NBTFieldHandlers.addNBTHandler(Float.class, (key, tag, original) -> Float.valueOf(tag.m_128457_(key)), (key, val, tag) -> tag.m_128350_(key, val.floatValue()));
        NBTFieldHandlers.addNBTHandler(Double.TYPE, (key, tag, original) -> tag.m_128459_(key), (key, val, tag) -> tag.m_128347_(key, val.doubleValue()));
        NBTFieldHandlers.addNBTHandler(Double.class, (key, tag, original) -> tag.m_128459_(key), (key, val, tag) -> tag.m_128347_(key, val.doubleValue()));
        NBTFieldHandlers.addNBTHandler(Long.TYPE, (key, tag, original) -> tag.m_128454_(key), (key, val, tag) -> tag.m_128356_(key, val.longValue()));
        NBTFieldHandlers.addNBTHandler(Long.class, (key, tag, original) -> tag.m_128454_(key), (key, val, tag) -> tag.m_128356_(key, val.longValue()));
        NBTFieldHandlers.addNBTHandler(String.class, (key, tag, original) -> tag.m_128441_(key) ? tag.m_128461_(key) : null, (key, s, tag) -> {
            if (s != null) {
                tag.m_128359_(key, s);
            }
        });
        NBTFieldHandlers.addNBTHandler(ItemStack.class, (key, tag, original) -> ItemStack.m_41712_((CompoundTag)tag.m_128469_(key)), (key, itemStack, tag) -> tag.m_128365_(key, (Tag)itemStack.serializeNBT()));
        NBTFieldHandlers.addNBTHandler(ItemStackHandler.class, (key, tag, original) -> {
            original.deserializeNBT(tag.m_128469_(key));
            return original;
        }, (key, itemStackHandler, tag) -> tag.m_128365_(key, (Tag)itemStackHandler.serializeNBT()));
        NBTFieldHandlers.addNBTHandler(Enum.class, (key, tag, original) -> {
            CompoundTag enumTag = tag.m_128469_(key);
            try {
                Class<?> clz = Class.forName(enumTag.m_128461_("class"));
                return Enum.valueOf(clz, enumTag.m_128461_("value"));
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Could not find enum '{}' during NBT deserialization", (Object)tag.m_128461_(key));
                e.printStackTrace();
                return null;
            }
        }, (key, anEnum, tag) -> {
            CompoundTag result = new CompoundTag();
            result.m_128359_("class", anEnum.getClass().getName());
            result.m_128359_("value", anEnum.name());
            tag.m_128365_(key, (Tag)result);
        });
        NBTFieldHandlers.addNBTHandler(Class.class, (key, tag, original) -> {
            if (key.equals("") || !tag.m_128441_(key)) {
                return null;
            }
            try {
                return Class.forName(tag.m_128461_(key));
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Could not find class '{}' during NBT deserialization", (Object)tag.m_128461_(key));
                e.printStackTrace();
                return null;
            }
        }, (key, aClass, tag) -> {
            if (aClass != null) {
                tag.m_128359_(key, aClass.getName());
            }
        });
        NBTFieldHandlers.addNBTHandler(ResourceLocation.class, (key, tag, original) -> {
            if (!tag.m_128441_(key)) {
                return null;
            }
            return new ResourceLocation(tag.m_128461_(key));
        }, (key, resourceLocation, tag) -> {
            if (resourceLocation == null) {
                return;
            }
            tag.m_128359_(key, resourceLocation.toString());
        });
        NBTFieldHandlers.addNBTHandler(BlockPos.class, (key, tag, original) -> {
            CompoundTag container = tag.m_128469_(key);
            return new BlockPos(container.m_128451_("x"), container.m_128451_("y"), container.m_128451_("z"));
        }, (key, pos, tag) -> {
            CompoundTag container = new CompoundTag();
            container.m_128405_("x", pos.m_123341_());
            container.m_128405_("y", pos.m_123342_());
            container.m_128405_("z", pos.m_123343_());
            tag.m_128365_(key, (Tag)container);
        });
        NBTFieldHandlers.addNBTHandler(BlockState.class, (key, tag, original) -> BlockStateSerializationHelper.deserializeBlockState(tag.m_128469_(key)), (key, blockState, tag) -> tag.m_128365_(key, (Tag)BlockStateSerializationHelper.serializeBlockStateToNBT(blockState)));
        NBTFieldHandlers.addNBTHandler(UUID.class, (key, tag, original) -> {
            if (!tag.m_128441_(key)) {
                return null;
            }
            CompoundTag containerTag = tag.m_128469_(key);
            return containerTag.m_128342_("");
        }, (key, uuid, tag) -> {
            if (uuid == null) {
                return;
            }
            CompoundTag containerTag = new CompoundTag();
            containerTag.m_128362_("", uuid);
            tag.m_128365_(key, (Tag)containerTag);
        });
        NBTFieldHandlers.addNBTHandler(INBTSerializable.class, (key, tag, original) -> {
            CompoundTag containerTag = tag.m_128469_(key);
            String className = containerTag.m_128461_("class");
            try {
                Class<?> clz = Class.forName(className);
                INBTSerializable obj = (INBTSerializable)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
                obj.deserializeNBT((Tag)containerTag.m_128469_("data"));
                return obj;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }, (key, INBTSerializable2, tag) -> {
            CompoundTag containerTag = new CompoundTag();
            containerTag.m_128359_("class", INBTSerializable2.getClass().getName());
            containerTag.m_128365_("data", INBTSerializable2.serializeNBT());
            tag.m_128365_(key, (Tag)containerTag);
        });
        NBTFieldHandlers.addNBTHandler(Map.class, (key, tag, original) -> {
            CompoundTag containerTag = tag.m_128469_(key);
            if (!containerTag.m_128441_("isEmpty") || containerTag.m_128471_("isEmpty") || !containerTag.m_128441_("entries")) {
                return new HashMap();
            }
            HashMap<Map, Map> result = new HashMap<Map, Map>();
            try {
                Class<?> keyClass = Class.forName(containerTag.m_128461_("keyClass"));
                if (!NBTFieldHandlers.hasNBTHandler(keyClass)) {
                    LOGGER.warn("No NBT deserialization methods for keys in map (type='{}') exists.", keyClass);
                    return new HashMap();
                }
                Class<?> valueClass = Class.forName(containerTag.m_128461_("valueClass"));
                if (!NBTFieldHandlers.hasNBTHandler(valueClass)) {
                    LOGGER.warn("No NBT deserialization methods for values in map (type='{}') exists.", valueClass);
                    return new HashMap();
                }
                NbtReader keyReader = (NbtReader)NBTFieldHandlers.getNBTHandler(keyClass).getLeft();
                NbtReader valueReader = (NbtReader)NBTFieldHandlers.getNBTHandler(valueClass).getLeft();
                for (Tag baseTag : containerTag.m_128437_("entries", 10)) {
                    CompoundTag entry = (CompoundTag)baseTag;
                    Map keyObject = keyReader.read("key", entry, original);
                    Map valueObject = valueReader.read("value", entry, original);
                    result.put(keyObject, valueObject);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return result;
        }, (key, map, tag) -> {
            CompoundTag containerTag = new CompoundTag();
            containerTag.m_128379_("isEmpty", map.isEmpty());
            if (!map.isEmpty()) {
                Class<?> keyClass = map.keySet().toArray()[0].getClass();
                if (!NBTFieldHandlers.hasNBTHandler(keyClass)) {
                    LOGGER.warn("No NBT deserialization methods for keys in map (type='{}') exists.", keyClass);
                    return;
                }
                Class<?> valueClass = map.values().toArray()[0].getClass();
                if (!NBTFieldHandlers.hasNBTHandler(valueClass)) {
                    LOGGER.warn("No NBT deserialization methods for values in map (type='{}') exists.", valueClass);
                    return;
                }
                containerTag.m_128359_("keyClass", keyClass.getName());
                containerTag.m_128359_("valueClass", valueClass.getName());
                NbtWriter keyWriter = (NbtWriter)NBTFieldHandlers.getNBTHandler(keyClass).getRight();
                NbtWriter valueWriter = (NbtWriter)NBTFieldHandlers.getNBTHandler(valueClass).getRight();
                ListTag data = new ListTag();
                for (Map.Entry e : map.entrySet()) {
                    CompoundTag entryTag = new CompoundTag();
                    Map.Entry entry = e;
                    keyWriter.write("key", entry.getKey(), entryTag);
                    valueWriter.write("value", entry.getValue(), entryTag);
                    data.add((Object)entryTag);
                }
                containerTag.m_128365_("entries", (Tag)data);
            }
            tag.m_128365_(key, (Tag)containerTag);
        });
        NBTFieldHandlers.addNBTHandler(List.class, (key, tag, original) -> {
            ArrayList<List> result = new ArrayList<List>();
            CompoundTag containerTag = tag.m_128469_(key);
            if (!containerTag.m_128441_("isEmpty") || containerTag.m_128471_("isEmpty") || !containerTag.m_128441_("values")) {
                return result;
            }
            try {
                Class<?> valueClass = Class.forName(containerTag.m_128461_("valueClass"));
                if (!NBTFieldHandlers.hasNBTHandler(valueClass)) {
                    LOGGER.warn("No NBT deserialization methods for values in list (type='{}') exists.", valueClass);
                    return result;
                }
                NbtReader reader = (NbtReader)NBTFieldHandlers.getNBTHandler(valueClass).getLeft();
                for (Tag baseTag : containerTag.m_128437_("values", 10)) {
                    CompoundTag entry = (CompoundTag)baseTag;
                    List value = reader.read("data", entry, original);
                    result.add(value);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return result;
        }, (key, list, tag) -> {
            CompoundTag containerTag = new CompoundTag();
            containerTag.m_128379_("isEmpty", list.isEmpty());
            if (!list.isEmpty()) {
                Class<?> valueClass = list.get(0).getClass();
                if (!NBTFieldHandlers.hasNBTHandler(valueClass)) {
                    LOGGER.warn("No NBT serialization methods for values in list (type='{}') exists.", (Object)valueClass.getName());
                    return;
                }
                containerTag.m_128359_("valueClass", valueClass.getName());
                NbtWriter writer = (NbtWriter)NBTFieldHandlers.getNBTHandler(valueClass).getRight();
                ListTag data = new ListTag();
                for (Object e : list) {
                    CompoundTag entryContainerTag = new CompoundTag();
                    writer.write("data", e, entryContainerTag);
                    data.add((Object)entryContainerTag);
                }
                containerTag.m_128365_("values", (Tag)data);
            }
            tag.m_128365_(key, (Tag)containerTag);
        });
        NBTFieldHandlers.addNBTHandler(Queue.class, (key, tag, original) -> {
            CompoundTag containerTag = tag.m_128469_(key);
            if (!containerTag.m_128441_("isEmpty") || containerTag.m_128471_("isEmpty") || !containerTag.m_128441_("values")) {
                return new ArrayDeque();
            }
            ArrayDeque<Queue> result = new ArrayDeque<Queue>();
            try {
                Class<?> valueClass = Class.forName(containerTag.m_128461_("valueClass"));
                if (!NBTFieldHandlers.hasNBTHandler(valueClass)) {
                    LOGGER.warn("No NBT deserialization methods for values in queue (type='{}') exists.", valueClass);
                    return new ArrayDeque();
                }
                NbtReader reader = (NbtReader)NBTFieldHandlers.getNBTHandler(valueClass).getLeft();
                for (Tag baseTag : containerTag.m_128437_("values", 10)) {
                    CompoundTag entry = (CompoundTag)baseTag;
                    Queue value = reader.read("data", entry, original);
                    result.add(value);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return result;
        }, (key, queue, tag) -> {
            CompoundTag containerTag = new CompoundTag();
            containerTag.m_128379_("isEmpty", queue.isEmpty());
            if (!queue.isEmpty()) {
                Class<?> valueClass = queue.peek().getClass();
                if (!NBTFieldHandlers.hasNBTHandler(valueClass)) {
                    LOGGER.warn("No NBT serialization methods for values in list (type='{}') exists.", (Object)valueClass.getName());
                    return;
                }
                containerTag.m_128359_("valueClass", valueClass.getName());
                NbtWriter writer = (NbtWriter)NBTFieldHandlers.getNBTHandler(valueClass).getRight();
                ListTag data = new ListTag();
                for (Object e : queue) {
                    CompoundTag entryContainerTag = new CompoundTag();
                    writer.write("data", e, entryContainerTag);
                    data.add((Object)entryContainerTag);
                }
                containerTag.m_128365_("values", (Tag)data);
            }
            tag.m_128365_(key, (Tag)containerTag);
        });
    }

    public static interface NbtWriter<T> {
        public void write(String var1, T var2, CompoundTag var3);
    }

    public static interface NbtReader<T> {
        public T read(String var1, CompoundTag var2, T var3);
    }
}

