/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.network;

import com.davenonymous.bonsaitrees3.libnonymous.base.BasePacket;
import com.davenonymous.bonsaitrees3.libnonymous.serialization.MultiblockBlockModel;
import com.davenonymous.bonsaitrees3.network.CutBonsaiPacket;
import com.davenonymous.bonsaitrees3.network.PacketEnabledSlots;
import com.davenonymous.bonsaitrees3.network.PacketModelToJson;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class Networking {
    public static SimpleChannel INSTANCE;
    private static final String CHANNEL_NAME = "channel";
    private static int ID;

    public static int nextID() {
        return ID++;
    }

    public static void registerMessages() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("bonsaitrees3", CHANNEL_NAME), () -> "1.0", s -> true, s -> true);
        INSTANCE.registerMessage(Networking.nextID(), CutBonsaiPacket.class, BasePacket::toBytes, CutBonsaiPacket::new, BasePacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        INSTANCE.registerMessage(Networking.nextID(), PacketEnabledSlots.class, BasePacket::toBytes, PacketEnabledSlots::new, BasePacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        INSTANCE.registerMessage(Networking.nextID(), PacketModelToJson.class, BasePacket::toBytes, PacketModelToJson::new, PacketModelToJson::doWork, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static void sendCutTreeToServer(BlockPos pos) {
        INSTANCE.sendToServer((Object)new CutBonsaiPacket(pos));
    }

    public static void sendEnabledSlotsMessage(List<Slot> inventorySlots) {
        INSTANCE.sendToServer((Object)new PacketEnabledSlots(inventorySlots));
    }

    public static void sendModelToClipboard(Connection target, MultiblockBlockModel model) {
        INSTANCE.sendTo((Object)new PacketModelToJson(model), target, NetworkDirection.PLAY_TO_CLIENT);
    }

    static {
        ID = 0;
    }
}

