/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.registry;

import com.davenonymous.bonsaitrees3.BonsaiTrees3;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees3.registry.soil.SoilInfo;
import com.davenonymous.bonsaitrees3.setup.Registration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public class SoilCompatibility {
    public static final SoilCompatibility INSTANCE = new SoilCompatibility();
    private Map<SoilInfo, Set<SaplingInfo>> treeCompatibility;
    private Map<SaplingInfo, Set<SoilInfo>> soilCompatibility;
    public boolean isReady = false;

    private void addCompatEntry(SoilInfo soil, SaplingInfo tree) {
        if (!this.soilCompatibility.containsKey(tree)) {
            this.soilCompatibility.put(tree, new HashSet());
        }
        this.soilCompatibility.get(tree).add(soil);
        if (!this.treeCompatibility.containsKey(soil)) {
            this.treeCompatibility.put(soil, new HashSet());
        }
        this.treeCompatibility.get(soil).add(tree);
    }

    public Set<SoilInfo> getValidSoilsForSapling(SaplingInfo sapling) {
        return this.soilCompatibility.getOrDefault(sapling, new HashSet());
    }

    public boolean canTreeGrowOnSoil(SaplingInfo sapling, SoilInfo soil) {
        if (!this.soilCompatibility.containsKey(sapling) || this.soilCompatibility.get(sapling) == null) {
            return false;
        }
        return this.soilCompatibility.get(sapling).contains(soil);
    }

    public boolean isValidSoil(ItemStack soilStack) {
        for (SoilInfo soil : this.treeCompatibility.keySet()) {
            if (!soil.ingredient.test(soilStack)) continue;
            return true;
        }
        return false;
    }

    public void update(Collection<Recipe<?>> recipes) {
        if (recipes == null || recipes.size() <= 0) {
            return;
        }
        List<SaplingInfo> saplings = recipes.stream().filter(r -> r.m_6671_() == Registration.RECIPE_TYPE_SAPLING).map(r -> (SaplingInfo)r).toList();
        List<SoilInfo> soils = recipes.stream().filter(r -> r.m_6671_() == Registration.RECIPE_TYPE_SOIL).map(r -> (SoilInfo)r).toList();
        this.treeCompatibility = new HashMap<SoilInfo, Set<SaplingInfo>>();
        this.soilCompatibility = new HashMap<SaplingInfo, Set<SoilInfo>>();
        HashMap reverseSoilTagMap = new HashMap();
        for (SoilInfo soil : soils) {
            for (String tag : soil.tags) {
                if (!reverseSoilTagMap.containsKey(tag)) {
                    reverseSoilTagMap.put(tag, new HashSet());
                }
                ((Set)reverseSoilTagMap.get(tag)).add(soil);
            }
        }
        for (SaplingInfo sapling : saplings) {
            for (String tag : sapling.tags) {
                if (!reverseSoilTagMap.containsKey(tag)) continue;
                for (SoilInfo soil : (Set)reverseSoilTagMap.get(tag)) {
                    this.addCompatEntry(soil, sapling);
                }
            }
        }
        BonsaiTrees3.LOGGER.info("Updated soil compatibility");
        this.isReady = true;
    }
}

