/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.registry.sapling;

import com.davenonymous.bonsaitrees3.libnonymous.base.RecipeData;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingDrop;
import com.davenonymous.bonsaitrees3.setup.Registration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class SaplingInfo
extends RecipeData {
    private final ResourceLocation id;
    public Ingredient ingredient;
    public int baseTicks;
    public ItemStack sapling;
    public ArrayList<SaplingDrop> drops;
    public Set<String> tags;

    public SaplingInfo(ResourceLocation id, Ingredient ingredient, int baseTicks) {
        this.id = id;
        this.ingredient = ingredient;
        this.baseTicks = baseTicks;
        this.drops = new ArrayList();
        this.tags = new HashSet<String>();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Registration.SAPLING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Registration.RECIPE_TYPE_SAPLING;
    }

    public int getRequiredTicks() {
        return this.baseTicks;
    }

    public void addDrop(SaplingDrop drop) {
        this.drops.add(drop);
        this.drops.sort((a, b) -> (int)(b.chance * 1000.0f) - (int)(a.chance * 1000.0f));
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public boolean isValidTag(String tag) {
        return this.tags.contains(tag);
    }

    public List<ItemStack> getRandomizedDrops(Random rand, int fortune, boolean hasSilkTouch) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (SaplingDrop drop : this.drops) {
            ItemStack dropStack;
            if (drop.requiresSilkTouch && !hasSilkTouch || (dropStack = drop.getRandomDrop(rand, fortune)).m_41619_()) continue;
            result.add(dropStack);
        }
        return result;
    }
}

