/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.registry.soil;

import com.davenonymous.bonsaitrees3.libnonymous.helper.BlockStateSerializationHelper;
import com.davenonymous.bonsaitrees3.libnonymous.helper.FluidStateSerializationHelper;
import com.davenonymous.bonsaitrees3.registry.soil.SoilInfo;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SoilSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<SoilInfo> {
    public SoilInfo fromJson(ResourceLocation recipeId, JsonObject json) {
        SoilInfo result;
        boolean isFluid;
        Ingredient soil = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("soil"));
        float tickModifier = 1.0f;
        if (json.has("tickModifier")) {
            tickModifier = json.get("tickModifier").getAsFloat();
        }
        if (isFluid = json.getAsJsonObject("display").has("fluid")) {
            state = FluidStateSerializationHelper.deserializeFluidState(json.getAsJsonObject("display"));
            result = new SoilInfo(recipeId, soil, state, tickModifier);
        } else {
            state = BlockStateSerializationHelper.deserializeBlockState(json.getAsJsonObject("display"));
            result = new SoilInfo(recipeId, soil, (BlockState)state, tickModifier);
        }
        if (json.has("compatibleSoilTags")) {
            JsonArray tagsJson = json.getAsJsonArray("compatibleSoilTags");
            for (JsonElement element : tagsJson) {
                String tag;
                if (!element.isJsonPrimitive() || (tag = element.getAsString()) == null) continue;
                result.addTag(tag);
            }
        }
        return result;
    }

    @Nullable
    public SoilInfo fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        SoilInfo result;
        boolean isFluid = buffer.readBoolean();
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        float tickModifier = buffer.readFloat();
        if (isFluid) {
            FluidState fluidState = FluidStateSerializationHelper.deserializeFluidState(buffer);
            result = new SoilInfo(recipeId, ingredient, fluidState, tickModifier);
        } else {
            BlockState blockState = BlockStateSerializationHelper.deserializeBlockState(buffer);
            result = new SoilInfo(recipeId, ingredient, blockState, tickModifier);
        }
        int tagCount = buffer.readInt();
        for (int i = 0; i < tagCount; ++i) {
            result.addTag(buffer.m_130277_());
        }
        return result;
    }

    public void toNetwork(FriendlyByteBuf buffer, SoilInfo soil) {
        buffer.writeBoolean(soil.isFluid);
        soil.ingredient.m_43923_(buffer);
        buffer.writeFloat(soil.tickModifier);
        if (soil.isFluid) {
            FluidStateSerializationHelper.serializeFluidState(buffer, soil.fluidState);
        } else {
            BlockStateSerializationHelper.serializeBlockState(buffer, soil.blockState);
        }
        buffer.writeInt(soil.tags.size());
        for (String tag : soil.tags) {
            buffer.m_130070_(tag);
        }
    }
}

