/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.setup;

import com.davenonymous.bonsaitrees3.blocks.BonsaiPotBlock;
import com.davenonymous.bonsaitrees3.blocks.BonsaiPotBlockEntity;
import com.davenonymous.bonsaitrees3.blocks.BonsaiPotContainer;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingRecipeHelper;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingSerializer;
import com.davenonymous.bonsaitrees3.registry.soil.SoilInfo;
import com.davenonymous.bonsaitrees3.registry.soil.SoilRecipeHelper;
import com.davenonymous.bonsaitrees3.registry.soil.SoilSerializer;
import com.davenonymous.bonsaitrees3.setup.ModSetup;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class Registration {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"bonsaitrees3");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"bonsaitrees3");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"bonsaitrees3");
    private static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"bonsaitrees3");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"bonsaitrees3");
    public static RecipeType<SoilInfo> RECIPE_TYPE_SOIL;
    public static SoilRecipeHelper RECIPE_HELPER_SOIL;
    public static final RegistryObject<RecipeSerializer<?>> SOIL_SERIALIZER;
    public static RecipeType<SaplingInfo> RECIPE_TYPE_SAPLING;
    public static SaplingRecipeHelper RECIPE_HELPER_SAPLING;
    public static final RegistryObject<RecipeSerializer<?>> SAPLING_SERIALIZER;
    public static final RegistryObject<Block> BONSAI_POT;
    public static final RegistryObject<Item> BONSAI_POT_ITEM;
    public static final RegistryObject<BlockEntityType<BonsaiPotBlockEntity>> BONSAI_POT_BLOCKENTITY;
    public static final RegistryObject<MenuType<BonsaiPotContainer>> BONSAI_POT_CONTAINER;
    public static final Item.Properties ITEM_PROPERTIES;

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        BLOCK_ENTITIES.register(bus);
        CONTAINERS.register(bus);
        RECIPE_SERIALIZERS.register(bus);
    }

    private static <B extends Block> RegistryObject<Item> fromBlock(RegistryObject<B> block) {
        return ITEMS.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), ITEM_PROPERTIES));
    }

    static {
        SOIL_SERIALIZER = RECIPE_SERIALIZERS.register("soil", () -> new SoilSerializer());
        SAPLING_SERIALIZER = RECIPE_SERIALIZERS.register("sapling", () -> new SaplingSerializer());
        BONSAI_POT = BLOCKS.register("bonsaipot", () -> new BonsaiPotBlock());
        BONSAI_POT_ITEM = Registration.fromBlock(BONSAI_POT);
        BONSAI_POT_BLOCKENTITY = BLOCK_ENTITIES.register("bonsaipot", () -> BlockEntityType.Builder.m_155273_(BonsaiPotBlockEntity::new, (Block[])new Block[]{(Block)BONSAI_POT.get()}).m_58966_(null));
        BONSAI_POT_CONTAINER = CONTAINERS.register("bonsaipot", () -> IForgeMenuType.create((windowId, inv, data) -> new BonsaiPotContainer(windowId, data.m_130135_(), inv, inv.f_35978_)));
        ITEM_PROPERTIES = new Item.Properties().m_41491_(ModSetup.ITEM_GROUP);
    }
}

