import requests
import re

header = {
    'User-Agent':'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36'
}
#定义全局变量，用于保存所有获取到的小说内容
story_all = []

#获取标题及章节链接地址
def main():
    url = input("请输入小说目录页地址（暂时仅支持‘http://www.xbiquge.la/’站内小说）：")
    book_name = input("请输入小说名称：")
    print("-----爬取开始-----")
    #获取目录页的HTML文本
    text = requests.get(url,header).content.decode('utf-8')
    #获取每个章节的章节名
    title = re.findall(r'<dd>.*?<a.*?>(.*?)</a>',text,re.DOTALL)
    #获取每个章节的链接地址
    loca = re.findall(r"<dd>.*?='(.*?)' >",text,re.DOTALL)
    #因为title和loca的长度相同，所以以索引的方式遍历，方便取值
    for i in range(len(title)):
        content(title[i],f'http://www.xbiquge.la{loca[i]}')
    #小说爬取完毕，开始保存
    print("@"*500)
    with open(r'%s.txt'%book_name, 'w',encoding='utf-8')as file:
        #遍历每一项，按顺序保存章节名和章节内容
        for story in story_all:
            file.write(story['title']+'\n')
            print(story['title'])
            file.write(story['story'])

#解析章节内容并保存
def content(title,url):
    #获取章节页的HTML文本
    text = requests.get(url,header).content.decode('utf-8')
    #因为之前写过直接爬取所有内容的，爬取出来的文本都带有\r不好处理
    #所以就一句一句的获取了
    story_content = re.findall(r'&nbsp;&nbsp;&nbsp;&nbsp;(.*?)<br',text,re.DOTALL)
    #因为章节名中有“”空格，没办法作为文件名，所以把空格去掉
    title = re.sub(' ','-',title)
    #有时候不知道为什么小说内容会爬取到一个空数组，所以这里添加了一个检测程序
    #如果爬取到的为空，就重新爬取，直到获取到为止
    if story_content==[]:
        content(title,url)
        return 0
    story=""
    #前面提到，因为我是一句一句爬取的，所以这里做一下拼接，顺便去空格
    for story_contents in story_content:
        story = story+story_contents.strip()+'\n'
    #将章节名称和章节内容保存为一个字典
    this_story = {
        "title":title,
        "story":story
    }
    print(this_story['title'])
    #将字典添加到开头定义的全局变量中
    story_all.append(this_story)

if __name__ == "__main__":
    main()