class X2Ability_CheatVest extends X2Ability config (CheatVest);

var config int GiveHP;
var config int GiveAim;
var config int GiveDodge;
var config int GiveWill;
var config int GiveArmor;
var config int GiveDefense;
var config int GiveHacking;
var config int GiveMobility;
var config int GiveShield;
var config int GiveRegen;
var config int GiveCriticalChance;
var config int GivePierce;

// Add our abilities here.
static function array<X2DataTemplate> CreateTemplates()
{
	local array<X2DataTemplate> CV;

	// Add the new ability needed by CheatVest.
	// This controls the various stat bonuses.
	CV.AddItem(CheatVest_Ability());

	return CV;
}

// This is the main CheatVest ability that enables control of the stats.
static function X2AbilityTemplate CheatVest_Ability()
{
	local X2AbilityTemplate                 Template;	
	local X2Effect_PersistentStatChange		PersistentStatChangeEffect;
	local X2Effect_Regeneration				RegenerationEffect;
	local bool								statChanged;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'CheatVestAbility');

	// We use the nanofiber vest as our icon.
	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_item_nanofibervest";

	Template.AbilitySourceName = 'eAbilitySource_Item';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;
	Template.bDisplayInUITacticalText = false;
	
	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;
	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);

	PersistentStatChangeEffect = new class'X2Effect_PersistentStatChange';
	PersistentStatChangeEffect.BuildPersistentEffect(1, true, false, false);
	PersistentStatChangeEffect.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage, false, , Template.AbilitySourceName);

	// Do we give an extra HP bonus?
	if (default.GiveHP > 0)
	{
		statChanged = true;
		PersistentStatChangeEffect.AddPersistentStatChange(eStat_HP, default.GiveHP);
	}

	// Aim bonus?
	if (default.GiveAim > 0)
	{
		statChanged = true;
		PersistentStatChangeEffect.AddPersistentStatChange(eStat_Offense, default.GiveAim);
	}

	// Will bonus?
	if (default.GiveWill > 0)
	{
		statChanged = true;
		PersistentStatChangeEffect.AddPersistentStatChange(eStat_Will, default.GiveWill);
	}

	// Dodge bonus?
	if (default.GiveDodge > 0)
	{
		statChanged = true;
		PersistentStatChangeEffect.AddPersistentStatChange(eStat_Dodge, default.GiveDodge);
	}

	// Armor bonus?
	if (default.GiveArmor > 0)
	{
		statChanged = true;

		// The armor always blocks shots.
		PersistentStatChangeEffect.AddPersistentStatChange(eStat_ArmorChance, 100);
		PersistentStatChangeEffect.AddPersistentStatChange(eStat_ArmorMitigation, default.GiveArmor);
	}

	// Defense bonus?
	if (default.GiveDefense > 0)
	{
		statChanged = true;
		PersistentStatChangeEffect.AddPersistentStatChange(eStat_Defense, default.GiveDefense);
	}

	// Hacking bonus?
	if (default.GiveHacking > 0)
	{
		statChanged = true;
		PersistentStatChangeEffect.AddPersistentStatChange(eStat_Hacking, default.GiveHacking);
	}

	// Mobility bonus?
	if (default.GiveMobility > 0)
	{
		statChanged = true;
		PersistentStatChangeEffect.AddPersistentStatChange(eStat_Mobility, default.GiveMobility);
	}

	// Default shield at the start of a turn?
	if (default.GiveShield > 0)
	{
		statChanged = true;
		PersistentStatChangeEffect.AddPersistentStatChange(eStat_ShieldHP, default.GiveShield);
	}

	if (default.GiveCriticalChance > 0)
	{
		statChanged = true;
		PersistentStatChangeEffect.AddPersistentStatChange(eStat_CritChance, default.GiveCriticalChance);
	}

	//  Armor piercing?
	if (default.GivePierce > 0)
	{
		statChanged = true;
		PersistentStatChangeEffect.AddPersistentStatChange(eStat_ArmorPiercing, default.GivePierce);
	}

	// Any stats changed?
	if (statChanged)
	{
		Template.AddTargetEffect(PersistentStatChangeEffect);
	}

	// Do they want regeneration?
	if (default.GiveRegen > 0)
	{
		// BUG(me): Does not yet show the regeration take effect.
		RegenerationEffect = new class'X2Effect_Regeneration';
		RegenerationEffect.BuildPersistentEffect(1, true, true, false, eGameRule_PlayerTurnBegin);
		RegenerationEffect.HealAmount = default.GiveRegen;
		Template.AddTargetEffect(RegenerationEffect);
	}

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;

	return Template;	
}