class X2Item_CheatVest extends X2Item config (CheatVest);

var config bool bMindshield;
var config bool bGrapple;
var config bool bWraith;
var config bool bShadowstep;
var config bool bSquadsight;
var config bool bFortress;
var config bool bTeleport;

// How much this costs.
var config int CostSupplies;
var config int CostAlienAlloys;
var config int CostElerium;

static function array<X2DataTemplate> CreateTemplates()
{
	local array<X2DataTemplate> CV;

	// Add the CheatPCS itself now.
	CV.AddItem(CheatVest_Item());
	
	return CV;
}

static function X2DataTemplate CheatVest_Item()
{
	local X2EquipmentTemplate Template;
	local ArtifactCost Resources;

	`CREATE_X2TEMPLATE(class'X2EquipmentTemplate', Template, 'CheatVest');
	Template.ItemCat = 'defense';
	Template.InventorySlot = eInvSlot_Utility;
	Template.strImage = "img:///UILibrary_StrategyImages.X2InventoryIcons.Inv_Nano_Fiber_Vest";
	Template.EquipSound = "StrategyUI_Vest_Equip";
	Template.CanBeBuilt = true;
	Template.TradingPostValue = 20;
	Template.PointsToComplete = 0;
	Template.Tier = 0;

	// Display any bonuses given, part of the CheatVestAbility which we give below.
	// Do we give an extra HP bonus?
	if (class'X2Ability_CheatVest'.default.GiveHP > 0)
	{
		Template.SetUIStatMarkup(class'XLocalizedData'.default.HealthLabel, eStat_HP, class'X2Ability_CheatVest'.default.GiveHP, true);
	}

	// Aim bonus?
	if (class'X2Ability_CheatVest'.default.GiveAim > 0)
	{
		Template.SetUIStatMarkup(class'XLocalizedData'.default.AimLabel, eStat_Offense, class'X2Ability_CheatVest'.default.GiveAim, true);
	}

	// Will bonus?
	if (class'X2Ability_CheatVest'.default.GiveWill > 0)
	{
		Template.SetUIStatMarkup(class'XLocalizedData'.default.WillLabel, eStat_Will, class'X2Ability_CheatVest'.default.GiveWill);
	}

	// Dodge bonus?
	if (class'X2Ability_CheatVest'.default.GiveDodge > 0)
	{
		Template.SetUIStatMarkup(class'XLocalizedData'.default.DodgeLabel, eStat_Dodge, class'X2Ability_CheatVest'.default.GiveDodge);
	}

	// Armor bonus?
	if (class'X2Ability_CheatVest'.default.GiveArmor > 0)
	{
		Template.SetUIStatMarkup(class'XLocalizedData'.default.ArmorLabel, eStat_ArmorMitigation, class'X2Ability_CheatVest'.default.GiveArmor);
	}

	// Defense bonus?
	if (class'X2Ability_CheatVest'.default.GiveDefense > 0)
	{
		Template.SetUIStatMarkup(class'XLocalizedData'.default.DefenseLabel, eStat_Defense, class'X2Ability_CheatVest'.default.GiveDefense);
	}

	// Hacking bonus?
	if (class'X2Ability_CheatVest'.default.GiveHacking > 0)
	{
		Template.SetUIStatMarkup(class'XLocalizedData'.default.TechStat, eStat_Hacking, class'X2Ability_CheatVest'.default.GiveHacking);
	}

	// Mobility bonus?
	if (class'X2Ability_CheatVest'.default.GiveMobility > 0)
	{
		Template.SetUIStatMarkup(class'XLocalizedData'.default.MobilityLabel, eStat_Mobility, class'X2Ability_CheatVest'.default.GiveMobility);
	}

	// Do they regenerate?
	if (class'X2Ability_CheatVest'.default.GiveRegen > 0)
	{
		Template.SetUIStatMarkup(class'XLocalizedData'.default.RegenLabel, , class'X2Ability_CheatVest'.default.GiveRegen);
	}

	if (class'X2Ability_CheatVest'.default.GiveCriticalChance > 0)
	{
		Template.SetUIStatMarkup(class'XLocalizedData'.default.CriticalChanceBonusLabel, eStat_CritChance, class'X2Ability_CheatVest'.default.GiveCriticalChance);
	}

	if (class'X2Ability_CheatVest'.default.GivePierce > 0)
	{
		Template.SetUIStatMarkup(class'XLocalizedData'.default.PierceLabel, eStat_ArmorPiercing, class'X2Ability_CheatVest'.default.GivePierce);
	}

	// The ability that enables us to change the soldier stats.
	Template.Abilities.AddItem('CheatVestAbility');

	// We like the MindShield ability, so we can't be controlled, paniced, etc.
	if (default.bMindshield)
	{
		Template.Abilities.AddItem('MindShield');
	}

	// Grapple is nice.
	if (default.bGrapple)
	{
		Template.Abilities.AddItem('GrapplePowered');
	}

	// Teleport?
	if (default.bTeleport)
	{
		// BUG(me): Animations do not play.
		Template.Abilities.AddItem('Teleport');
	}

	// Passing through walls is also a nice thing.
	if (default.bWraith)
	{
		Template.Abilities.AddItem('WallPhasing');
	}

	// Shadowstep, so we don't trigger Overwatch against us.
	if (default.bShadowstep)
	{
		Template.Abilities.AddItem('Shadowstep');
	}

	// We like to shoot from a distance, K?
	if (default.bSquadsight)
	{
		Template.Abilities.AddItem('Squadsight');
	}

	// We don't like being hurt - Fire, Poison, Acid, etc - Go away.
	if (default.bFortress)
	{
		Template.Abilities.AddItem('Fortress');
	}

	// The costs of the vest.
	// How many supplies?
	if (default.CostSupplies > 0)
	{
		Resources.ItemTemplateName = 'Supplies';
		Resources.Quantity = default.CostSupplies;
		Template.Cost.ResourceCosts.AddItem(Resources);
	}

	// Any alien alloys?
	if (default.CostAlienAlloys > 0)
	{
		Resources.ItemTemplateName = 'AlienAlloy';
		Resources.Quantity = default.CostAlienAlloys;
		Template.Cost.ResourceCosts.AddItem(Resources);
	}

	// Any elerium costs?
	if (default.CostElerium > 0)
	{
		Resources.ItemTemplateName = 'EleriumDust';
		Resources.Quantity = default.CostElerium;
		Template.Cost.ResourceCosts.AddItem(Resources);
	}

	return Template;
}