class X2Effect_ApplyFlareTargetToWorld extends X2Effect_Persistent;

private function DoTargetFX(XComGameState_Effect TargetEffect, out VisualizationTrack BuildTrack, XComGameStateContext Context, name EffectApplyResult, bool bStopEffect)
{
	local X2Action_PlayEffect FlarePlayEffect;
	local X2Action_StartStopSound SoundAction;

	if( EffectApplyResult != 'AA_Success' )
	{
		`LOG("Lucubration Infantry Class: Flare effect skipped (" @ EffectApplyResult @ ").");
		return;
	}

	`LOG("Lucubration Infantry Class: " @ bStopEffect ? "Removing" : "Adding" @ " Flare effect to world.");
	
	// The first value in the InputContext.TargetLocations is the desired landing posiiton. Either start or stop showing the flare effect there
	FlarePlayEffect = X2Action_PlayEffect(class'X2Action_PlayEffect'.static.AddToVisualizationTrack(BuildTrack, Context));
	FlarePlayEffect.EffectName = `CONTENT.ATTFlareEffectPathName;
	FlarePlayEffect.bStopEffect = bStopEffect;
	FlarePlayEffect.EffectLocation = TargetEffect.ApplyEffectParameters.AbilityInputContext.TargetLocations[0];
	
	if (!bStopEffect)
	{
		`LOG("Lucubration Infantry Class: Playing Flare audio effect.");

		// Play Target audio
		//PlayAKEvent(AkEvent'SoundTacticalUI.TacticalUI_DropZonePlacement');

		//class'WorldInfo'.static.GetWorldInfo().PlayAKEvent(AkEvent'SoundTacticalUI.TacticalUI_DropZonePlacement');

		SoundAction = X2Action_StartStopSound(class'X2Action_StartStopSound'.static.AddToVisualizationTrack(BuildTrack, Context));
		SoundAction.Sound = new class'SoundCue';
		SoundAction.Sound.AkEventOverride = AkEvent'SoundTacticalUI.TacticalUI_DropZonePlacement';
		SoundAction.iAssociatedGameStateObjectId = TargetEffect.ObjectID;
		SoundAction.bStartPersistentSound = !bStopEffect;
		SoundAction.bStopPersistentSound = bStopEffect;
		SoundAction.bIsPositional = true;
		SoundAction.vWorldPosition = TargetEffect.ApplyEffectParameters.AbilityInputContext.TargetLocations[0];

		// Play the sound cue
		//SoundCueAction = X2Action_PlaySoundAndFlyOver(class'X2Action_PlaySoundAndFlyOver'.static.AddToVisualizationTrack(BuildTrack, Context));
		//SoundCueAction.SetSoundAndFlyOverParameters(SoundCue'SoundTacticalUI.TacticalUI_DropZonePlacement', "", '', eColor_Good);
	}

	`LOG("Lucubration Infantry Class: " @ bStopEffect ? "Removed" : "Added" @ " Flare effect to world.");
}

simulated function AddX2ActionsForVisualization(XComGameState VisualizeGameState, out VisualizationTrack BuildTrack, name EffectApplyResult)
{
	local XComGameState_Effect TargetEffect;

	foreach VisualizeGameState.IterateByClassType(class'XComGameState_Effect', TargetEffect)
	{
		if( TargetEffect.GetX2Effect() == self )
		{
			break;
		}
	}

	if( TargetEffect == none )
	{
		`RedScreen("Lucubration Infantry Class: Could not find Flare World Target effect.");
		return;
	}

	DoTargetFX(TargetEffect, BuildTrack, VisualizeGameState.GetContext(), EffectApplyResult, false);
}

simulated function AddX2ActionsForVisualization_Removed(XComGameState VisualizeGameState, out VisualizationTrack BuildTrack, const name EffectApplyResult, XComGameState_Effect RemovedEffect)
{
	DoTargetFX(RemovedEffect, BuildTrack, VisualizeGameState.GetContext(), EffectApplyResult, true);
}

defaultproperties
{
	EffectName="ApplyFlareTargetToWorld"
}