class X2Effect_ExplosiveActionRecovery extends X2Effect_Persistent;
	
var int RecoveryActionPoints;

simulated function OnEffectRemoved(const out EffectAppliedData ApplyEffectParameters, XComGameState NewGameState, bool bCleansed, XComGameState_Effect RemovedEffectState)
{
	local XComGameState_Unit UnitState;
	local int i;
	local int ActionPointsRemoved;
	local name ActionPointType;

	UnitState = XComGameState_Unit(NewGameState.CreateStateObject(class'XComGameState_Unit', ApplyEffectParameters.TargetStateObjectRef.ObjectID));
	if (UnitState != none)
	{
		ActionPointType = class'X2CharacterTemplateManager'.default.StandardActionPoint;

		//`LOG("Lucubration Infantry Class: Explosive Action Recovery removal started with " @ string(UnitState.ActionPoints.Length) @ " action points on unit " @ UnitState.GetFullName() @ ".");

		ActionPointsRemoved = 0;

		for (i = UnitState.ActionPoints.Length - 1; i >= 0 && ActionPointsRemoved < RecoveryActionPoints; --i)
		{
			if (UnitState.ActionPoints[i] == ActionPointType)
			{
				// Remove recovery action point
				UnitState.ActionPoints.Remove(i, RecoveryActionPoints);
				ActionPointsRemoved++;

				//`LOG("Lucubration Infantry Class: Explosive Action Recovery removed " @ string(RecoveryActionPoints) @ string(ActionPointType) @ " action points from unit " @ UnitState.GetFullName() @ ".");
			}
		}

		//`LOG("Lucubration Infantry Class: Explosive Action Recovery removal ended with " @ string(UnitState.ActionPoints.Length) @ " action points on unit " @ UnitState.GetFullName() @ ".");
	}

	super.OnEffectRemoved(ApplyEffectParameters, NewGameState, bCleansed, RemovedEffectState);
}

simulated function AddX2ActionsForVisualization_Removed(XComGameState VisualizeGameState, out VisualizationTrack BuildTrack, const name EffectApplyResult, XComGameState_Effect RemovedEffect)
{
	local X2Action_PlaySoundAndFlyOver SoundAndFlyOver;
	
	SoundAndFlyOver = X2Action_PlaySoundAndFlyOver(class'X2Action_PlaySoundAndFlyOver'.static.AddToVisualizationTrack(BuildTrack, VisualizeGameState.GetContext()));
	SoundAndFlyOver.SetSoundAndFlyOverParameters(None, FriendlyName, '', eColor_Bad);
}