// This class is the passive effect that listens for attacks that trigger the Stick and Move active effect
class X2Effect_StickAndMove extends X2Effect_Persistent
	config(LucubrationsInfantryClass);

simulated protected function OnEffectAdded(const out EffectAppliedData ApplyEffectParameters, XComGameState_BaseObject kNewTargetState, XComGameState NewGameState, XComGameState_Effect NewEffectState)
{
	local XComGameState_Unit TargetUnit;
	local XComGameState_Effect_StickAndMove StickAndMoveEffectState;
	local X2EventManager EventMgr;
	local Object ListenerObj;

	if (GetStickAndMoveComponent(NewEffectState) == none)
	{
		TargetUnit = XComGameState_Unit(kNewTargetState);

		// Create component and attach it to GameState_Effect, adding the new state object to the NewGameState container
		StickAndMoveEffectState = XComGameState_Effect_StickAndMove(NewGameState.CreateStateObject(class'XComGameState_Effect_StickAndMove'));
		StickAndMoveEffectState.UnitRef = TargetUnit.GetReference();
		NewEffectState.AddComponentObject(StickAndMoveEffectState);
		NewGameState.AddStateObject(StickAndMoveEffectState);
	
		EventMgr = `XEVENTMGR;
	
		// The gamestate component should handle the callback
		ListenerObj = StickAndMoveEffectState;

		EventMgr.RegisterForEvent(ListenerObj, 'AbilityActivated', class'XComGameState_Effect_StickAndMove'.static.OnAbilityActivated, ELD_OnStateSubmitted);

		//`LOG("Lucubration Infantry Class: Stick and Move passive effect registered for events.");
	}
}

static function XComGameState_Effect_StickAndMove GetStickAndMoveComponent(XComGameState_Effect Effect)
{
    if (Effect != none) 
        return XComGameState_Effect_StickAndMove(Effect.FindComponentObject(class'XComGameState_Effect_StickAndMove'));
    return none;
}