class X2Effect_ZoneOfControl extends X2Effect_Persistent;

var name AbilityToActivate;
var name ActionPointName;
var int ReactionFireRadius;

simulated protected function OnEffectAdded(const out EffectAppliedData ApplyEffectParameters, XComGameState_BaseObject kNewTargetState, XComGameState NewGameState, XComGameState_Effect NewEffectState)
{
	local XComGameState_Unit TargetUnit;
	local XComGameState_Effect_ZoneOfControl ZoneOfControlEffectState;
	local X2EventManager EventMgr;
	local Object ListenerObj;

	if (GetZoneOfControlComponent(NewEffectState) == none)
	{
		TargetUnit = XComGameState_Unit(kNewTargetState);

		// Create component and attach it to GameState_Effect, adding the new state object to the NewGameState container
		ZoneOfControlEffectState = XComGameState_Effect_ZoneOfControl(NewGameState.CreateStateObject(class'XComGameState_Effect_ZoneOfControl'));
		ZoneOfControlEffectState.AbilityToActivate = AbilityToActivate;
		ZoneOfControlEffectState.ActionPointName = ActionPointName;
		ZoneOfControlEffectState.ReactionFireRadius = ReactionFireRadius;
		ZoneOfControlEffectState.ShooterRef = TargetUnit.GetReference();
		NewEffectState.AddComponentObject(ZoneOfControlEffectState);
		NewGameState.AddStateObject(ZoneOfControlEffectState);

		EventMgr = `XEVENTMGR;
	
		// The gamestate component should handle the callback
		ListenerObj = ZoneOfControlEffectState;
	
		EventMgr.RegisterForEvent(ListenerObj, 'ObjectMoved', class'XComGameState_Effect_ZoneOfControl'.static.OnObjectMoved, ELD_OnStateSubmitted);
		EventMgr.RegisterForEvent(ListenerObj, 'UnitMoveFinished', class'XComGameState_Effect_ZoneOfControl'.static.OnUnitMoveFinished, ELD_OnStateSubmitted);
		EventMgr.RegisterForEvent(ListenerObj, 'PlayerTurnEnded', class'XComGameState_Effect_ZoneOfControl'.static.OnPlayerTurnEnded, ELD_OnStateSubmitted);

		//`LOG("Lucubration Infantry Class: Zone of Control passive effect registered for events.");
	}
}

static function XComGameState_Effect_ZoneOfControl GetZoneOfControlComponent(XComGameState_Effect Effect)
{
    if (Effect != none) 
        return XComGameState_Effect_ZoneOfControl(Effect.FindComponentObject(class'XComGameState_Effect_ZoneOfControl'));
    return none;
}