class XComGameState_Effect_StickAndMove extends XComGameState_BaseObject
	config (LucubrationsInfantryClass);
	
var StateObjectReference UnitRef;

function EventListenerReturn OnAbilityActivated(Object EventData, Object EventSource, XComGameState GameState, Name EventID)
{
	local XComGameStateHistory History;
	local XComGameState_Ability AbilityState, ActiveAbilityState;
	local X2AbilityTemplate AbilityTemplate;
	local XComGameStateContext_Ability AbilityContext;
	local XComGameState_Unit UnitState;
	local name ActiveAbilityName, ActiveEffectName, CompareEffectName;
	local StateObjectReference AbilityRef;
	
	History = `XCOMHISTORY;
	
	//`LOG("Lucubration Infantry Class: Stick and Move event listener delegate invoked.");

	AbilityContext = XComGameStateContext_Ability(GameState.GetContext());
	if (AbilityContext == none)
	{
		//`LOG("Lucubration Infantry Class: Stick and Move not activated (no ability context).");
		return ELR_NoInterrupt;
	}
	
	AbilityTemplate = class'X2AbilityTemplateManager'.static.GetAbilityTemplateManager().FindAbilityTemplate(AbilityContext.InputContext.AbilityTemplateName);
	if (AbilityTemplate == none)
	{
		//`LOG("Lucubration Infantry Class: Stick and Move not activated by ability " @ string(AbilityTemplate.DataName) @ " (no ability template).");
		return ELR_NoInterrupt;
	}
	
	AbilityState = XComGameState_Ability(EventData);
	if (AbilityState == none)
	{
		//`LOG("Lucubration Infantry Class: Stick and Move not activated by ability " @ string(AbilityTemplate.DataName) @ " (no ability state).");
		return ELR_NoInterrupt;
	}

	if (AbilityContext.InputContext.SourceObject.ObjectID != UnitRef.ObjectID)
	{
		//`LOG("Lucubration Infantry Class: Stick and Move not activated by ability " @ string(AbilityTemplate.DataName) @ " (not Stick and Move unit).");
		return ELR_NoInterrupt;
	}

	UnitState = XComGameState_Unit(GameState.GetGameStateForObjectID(AbilityContext.InputContext.SourceObject.ObjectID));
	if (UnitState == none)
		UnitState = XComGameState_Unit(History.GetGameStateForObjectID(AbilityContext.InputContext.SourceObject.ObjectID));
	if (UnitState == none)
	{
		//`LOG("Lucubration Infantry Class: Stick and Move not activated by ability " @ string(AbilityTemplate.DataName) @ " (no unit).");
		return ELR_NoInterrupt;
	}

	// Check the type of ability
	if (AbilityTemplate.Hostility == eHostility_Offensive)
	{
		// Offensive abilities apply the mobility effect
		ActiveAbilityName = class'X2Ability_InfantryAbilitySet'.default.StickAndMoveMobilityAbilityName;
		ActiveEffectName = class'X2Ability_InfantryAbilitySet'.default.StickAndMoveMobilityEffectName;
	}
	else if (AbilityContext.InputContext.MovementPaths.Length > 0)
	{
		// Abilities with a movement component apply the dodge effect
		ActiveAbilityName = class'X2Ability_InfantryAbilitySet'.default.StickAndMoveDodgeAbilityName;
		ActiveEffectName = class'X2Ability_InfantryAbilitySet'.default.StickAndMoveDodgeEffectName;
	}
	else
	{
		// Other abilities are not relevant
		//`LOG("Lucubration Infantry Class: Stick and Move not activated by ability " @ string(AbilityTemplate.DataName) @ " (not attack or movement ability).");
	}
	
	foreach UnitState.AffectedByEffectNames(CompareEffectName)
	{
		if (ActiveEffectName == CompareEffectName)
		{
			//`LOG("Lucubration Infantry Class: Stick and Move not activated by ability " @ string(AbilityTemplate.DataName) @ " (Stick and Move effect " @ ActiveAbilityName @ " already active for unit).");
			return ELR_NoInterrupt;
		}
	}

	// Get the Stick and Move active ability from the source unit
	foreach UnitState.Abilities(AbilityRef)
	{
		ActiveAbilityState = XComGameState_Ability(History.GetGameStateForObjectID(AbilityRef.ObjectID));
		if (ActiveAbilityState.GetMyTemplateName() == ActiveAbilityName)
			break;
		ActiveAbilityState = none;
	}

	if (ActiveAbilityState == none)
	{
		//`LOG("Lucubration Infantry Class: Stick and Move not activated by ability " @ string(AbilityTemplate.DataName) @ " (no Stick and Move active ability).");
		return ELR_NoInterrupt;
	}
	
	ActiveAbilityState.AbilityTriggerAgainstSingleTarget(UnitState.GetReference(), false, GameState.HistoryIndex);

	//`LOG("Lucubration Infantry Class: Stick and Move effect " @ ActiveAbilityName @ " activated by ability " @ string(AbilityTemplate.DataName));
	
	return ELR_NoInterrupt;
}
