class XComGameState_Effect_ZoneOfControl extends XComGameState_BaseObject
	config (LucubrationsInfantryClass);

var name AbilityToActivate;
var name ActionPointName;
var int ReactionFireRadius;
var StateObjectReference ShooterRef;
var privatewrite array<StateObjectReference> ReactionFireTargets;

function EventListenerReturn OnObjectMoved(Object EventData, Object EventSource, XComGameState GameState, Name EventID)
{
	local XComGameStateHistory History;
	local StateObjectReference AbilityRef;
	local XComGameStateContext_Ability ActiveAbilityContext;
	local XComGameState_Ability ActiveAbilityState;
	local XComGameState_Unit Shooter, Target;
	local name CanShootCode;
	local XComGameState NewGameState;
	local int TargetDistanceInTiles;
	
	History = `XCOMHISTORY;
	
	//`LOG("Lucubration Infantry Class: Zone of Control 'ObjectMoved' event listener delegate invoked.");
	
	// Grab the target unit
	Target = XComGameState_Unit(EventData);
	if (Target == none)
	{
		//`LOG("Lucubration Infantry Class: Zone of Control not activated (no target).");

		return ELR_NoInterrupt;
	}

	// Check if the target has already been fired at
	if (ReactionFireTargets.Find('ObjectID', Target.ObjectID) != INDEX_NONE)
	{
		`LOG("Lucubration Infantry Class: Zone of Control not activated against unit " @ Target.GetFullName() @ " (Zone of Control already fired at this unit).");

		return ELR_NoInterrupt;
	}

	// Grab the shooter unit
	Shooter = XComGameState_Unit(GameState.GetGameStateForObjectID(ShooterRef.ObjectID));
	if (Shooter == none)
		Shooter = XComGameState_Unit(History.GetGameStateForObjectID(ShooterRef.ObjectID));
	if (Shooter == none)
	{
		`LOG("Lucubration Infantry Class: Zone of Control not activated against unit " @ Target.GetFullName() @ " (no shooter).");

		return ELR_NoInterrupt;
	}

	// Check if the target is an enemy to the shooter
	if (!Shooter.TargetIsEnemy(Target.ObjectID))
	{
		//`LOG("Lucubration Infantry Class: Zone of Control not activated by unit " @ Shooter.GetFullName() @ " against unit " @ Target.GetFullName() @ " (not an enemy).");

		return ELR_NoInterrupt;
	}

	// Check if the target is an enemy to the shooter
	if (Target.IsMindControlled())
	{
		`LOG("Lucubration Infantry Class: Zone of Control not activated by unit " @ Shooter.GetFullName() @ " against unit " @ Target.GetFullName() @ " (target is mind controlled, probably really our friend).");

		return ELR_NoInterrupt;
	}

	// Check range from shooter to target. Radius in config is given in tiles
	TargetDistanceInTiles = Shooter.TileDistanceBetween(Target);
	if (TargetDistanceInTiles > ReactionFireRadius)
	{
		//`LOG("Lucubration Infantry Class: Zone of Control not activated by unit " @ Shooter.GetFullName() @ " against unit " @ Target.GetFullName() @ " (out of range, " @ string(TargetDistanceInTiles) @ " > " @ string(ReactionFireRadius) @ ").");

		return ELR_NoInterrupt;
	}

	// Get the Zone of Control active ability from the shooter unit
	foreach Shooter.Abilities(AbilityRef)
	{
		ActiveAbilityState = XComGameState_Ability(History.GetGameStateForObjectID(AbilityRef.ObjectID));
		if (ActiveAbilityState.GetMyTemplateName() == AbilityToActivate)
			break;
		ActiveAbilityState = none;
	}

	if (ActiveAbilityState == none)
	{
		`LOG("Lucubration Infantry Class: Zone of Control not activated by unit " @ Shooter.GetFullName() @ " against unit " @ Target.GetFullName() @ " (no reaction fire ability).");

		return ELR_NoInterrupt;
	}
	
	if (ActionPointName != '')
	{
		`LOG("Lucubration Infantry Class: Zone of Control adding reserved action point to unit " @ Shooter.GetFullName() @ ".");
	
		// Grant an ability point for the shooter
		NewGameState = class'XComGameStateContext_ChangeContainer'.static.CreateChangeState(string(GetFuncName()));
		Shooter = XComGameState_Unit(NewGameState.CreateStateObject(Shooter.Class, Shooter.ObjectID));
		Shooter.ReserveActionPoints.AddItem(ActionPointName);
		NewGameState.AddStateObject(Shooter);
	}
	
	CanShootCode = ActiveAbilityState.CanActivateAbilityForObserverEvent(Target, Shooter);
	if (CanShootCode != 'AA_Success')
	{
		// If the shooter can't fire at the target, pick up our toys and go home
		History.CleanupPendingGameState(NewGameState);

		`LOG("Lucubration Infantry Class: Zone of Control not activated by unit " @ Shooter.GetFullName() @ " against unit " @ Target.GetFullName() @ " (shooter can't fire at this unit: " @ string(CanShootCode) @ ").");

		return ELR_NoInterrupt;
	}

	`TACTICALRULES.SubmitGameState(NewGameState);
	
	`LOG("Lucubration Infantry Class: Zone of Control reserved action point added to unit " @ Shooter.GetFullName() @ ".");
	
	// Register the target unit so we don't shoot at them twice
	ReactionFireTargets.AddItem(Target.GetReference());

	`LOG("Lucubration Infantry Class: Zone of Control target added " @ Target.GetFullName() @ ".");

	// Perform reaction fire against the target
	ActiveAbilityContext = class'XComGameStateContext_Ability'.static.BuildContextFromAbility(ActiveAbilityState, Shooter.ObjectID);
	if (!ActiveAbilityContext.Validate())
	{
		// Testing always seems to display this message, but the movement observer triggers pistol overwatch anyways. I guess it'll do?
		//`LOG("Lucubration Infantry Class: Zone of Control not activated by unit " @ Shooter.GetFullName() @ " against unit " @ Target.GetFullName() @ " (reaction fire ability context not valid)?");

		return ELR_NoInterrupt;
	}

	`TACTICALRULES.SubmitGameStateContext(ActiveAbilityContext);

	//`LOG("Lucubration Infantry Class: Zone of Control activated by unit " @ Shooter.GetFullName() @ " against unit " @ Target.GetFullName());

	return ELR_NoInterrupt;
}

function EventListenerReturn OnUnitMoveFinished(Object EventData, Object EventSource, XComGameState GameState, Name EventID)
{
	local XComGameState_Unit Target;
	local int i;
	
	//`LOG("Lucubration Infantry Class: Zone of Control 'UnitMoveFinished' event listener delegate invoked.");

	Target = XComGameState_Unit(EventData);
	if (Target == none)
	{
		//`LOG("Lucubration Infantry Class: Zone of Control target not removed (no target).");

		return ELR_NoInterrupt;
	}

	i = ReactionFireTargets.Find('ObjectID', Target.ObjectID);

	if (i == INDEX_NONE)
	{
		//`LOG("Lucubration Infantry Class: Zone of Control target " @ Target.GetFullName() @ " not removed (not a target).");

		return ELR_NoInterrupt;
	}

	// After a unit has finished moving, remove it from our reaction fire targets array. If it moves again, it can be shot at again
	ReactionFireTargets.Remove(i, 1);

	`LOG("Lucubration Infantry Class: Zone of Control target removed: " @ Target.GetFullName() @ ".");

	return ELR_NoInterrupt;
}

function EventListenerReturn OnPlayerTurnEnded(Object EventData, Object EventSource, XComGameState GameState, Name EventID)
{
	//`LOG("Lucubration Infantry Class: Zone of Control 'PlayerTurnEnded' event listener delegate invoked.");
	
	`LOG("Lucubration Infantry Class: Zone of Control targets cleared.");

	// Just to make sure we didn't miss anything, we're going to clear our reaction fire targets after every turn
	ReactionFireTargets.Length = 0;
	
	return ELR_NoInterrupt;
}
