BrightLamp = {}

BrightLamp.availableMaterialsList = {}
BrightLamp.neededMaterials = {}
BrightLamp.neededTools = {}
BrightLamp.toolsList = {}
BrightLamp.toolsText = {}
BrightLamp.playerCarpentrySkill = 0
BrightLamp.playerCanPlaster = false
BrightLamp.textTooltipHeader = " <RGB:2,2,2> <LINE> <LINE>" .. getText("Tooltip_craft_Needs") .. " : <LINE> "
BrightLamp.textCarpentryRed = ""
BrightLamp.textCarpentryGreen = ""
BrightLamp.textElectricityRed = ""
BrightLamp.textElectricityGreen = ""
BrightLamp.textBrightLightPoleDescription = getText("Tooltip_tip")
ISBuildMenu.cheat = false
BrightLamp.skillLevel =
{
	lighting = 4,
}

BrightLamp.ElectricityskillLevel =
{
	lighting = 2,
}

BrightLamp.doBuildMenu = function(player, context, worldobjects, test)
	if getCore():getGameMode() == "LastStand" then
		return
	end

	if test and ISWorldObjectContextMenu.Test then
		return true
	end

	if BrightLamp.haveAToolToBuildWithWith(player) then
		BrightLamp.playerCarpentrySkill = getSpecificPlayer(player):getPerkLevel(Perks.Woodwork)
		BrightLamp.playerelectricianSkill = getSpecificPlayer(player):getPerkLevel(Perks.Electricity)

		if BrightLamp.playerCarpentrySkill >= 8 or ISBuildMenu.cheat then
			BrightLamp.playerCanPlaster = true
		else
			BrightLamp.playerCanPlaster = false
		end

		BrightLamp.textCarpentryRed = " <RGB:1,0,0>" .. getText("IGUI_perks_Carpentry") .. " " .. BrightLamp.playerCarpentrySkill .. "/"
		BrightLamp.textCarpentryGreen = " <RGB:1,1,1>" .. getText("IGUI_perks_Carpentry") .. " "
		BrightLamp.textElectricityRed = " <RGB:1,0,0>" .. getText("IGUI_perks_Electricity") .. " " .. BrightLamp.playerelectricianSkill .. "/"
		BrightLamp.textElectricityGreen = " <RGB:1,1,1>" .. getText("IGUI_perks_Electricity") .. " "
		BrightLamp.buildMaterialsList(player)
		
		local _firstTierMenu = context:addOption(getText("ContextMenu_ExtendBuilding"), worldobjects, nil)
		local _secondTierMenu = ISContextMenu:getNew(context)
		context:addSubMenu(_firstTierMenu, _secondTierMenu)
		
		local _lightPostOption = _secondTierMenu:addOption(getText "ContextMenu_BrightLamp", worldobjects, nil)
		local _lightPostSubMenu = _secondTierMenu:getNew(_secondTierMenu)

		context:addSubMenu(_lightPostOption, _lightPostSubMenu)
		BrightLamp.lightPostMenuBuilder(_lightPostSubMenu, player)
	end
end

BrightLamp.haveAToolToBuildWithWith = function(player)

	local _inventory = getSpecificPlayer(player):getInventory()
	BrightLamp.toolsList = {}
	BrightLamp.toolsList["Hammer"] = _inventory:contains("Hammer") or _inventory:contains("HammerStone")
	BrightLamp.toolsList["Screwdriver"] = _inventory:contains("Screwdriver")
	BrightLamp.toolsList["HandShovel"] = _inventory:contains("HandShovel")
	BrightLamp.toolsList["Hammer"] = _inventory:contains("Hammer")
	BrightLamp.toolsList["Saw"] = _inventory:contains("Saw")
	BrightLamp.toolsList["Spade"] = _inventory:contains("Shovel")

	BrightLamp.toolsText["Hammer"] = getItemText "Hammer"
	BrightLamp.toolsText["Screwdriver"] = getItemText "Screwdriver"
	BrightLamp.toolsText["HandShovel"] = getItemText "Shovel"
	BrightLamp.toolsText["Saw"] = getItemText "Saw"
	BrightLamp.toolsText["Spade"] = getItemText "Spade"

	if BrightLamp.toolsList["Hammer"] or BrightLamp.toolsList["Screwdriver"] or ISBuildMenu.cheat then
		return true
	else
		return false
	end
end

BrightLamp.equipToolPrimary = function(object, player, tool)

	if BrightLamp.toolsList[tool] then

		ISInventoryPaneContextMenu.equipWeapon(getSpecificPlayer(player):getInventory():getItemFromType(tool), true, false, player)

		object.noNeedHammer = true
	end
end


BrightLamp.equipToolSecondary = function(object, player, tool)

	if BrightLamp.toolsList[tool] then

		ISInventoryPaneContextMenu.equipWeapon(getSpecificPlayer(player):getInventory():getItemFromType(tool), false, false, player)
	end
end

BrightLamp.buildMaterialsList = function(player)
	BrightLamp.availableMaterialsList = buildUtil.checkMaterialOnGround(getSpecificPlayer(player):getCurrentSquare())


	local _inventoryList = getSpecificPlayer(player):getInventory():getItems()
	local _size = _inventoryList:size()
	local _currentItemType = ""

	for i = 0, _size - 1 do
		_currentItemType = _inventoryList:get(i):getType()

		if BrightLamp.availableMaterialsList[_currentItemType] then
			BrightLamp.availableMaterialsList[_currentItemType] = BrightLamp.availableMaterialsList[_currentItemType] + 1
		else
			BrightLamp.availableMaterialsList[_currentItemType] = 1
		end
	end
end

BrightLamp.tooltipCheckForMaterial = function(materialRequired, amountNeeded, materialText, tooltip)
	if amountNeeded > 0 then
		local _thisItemCount = 0

		if BrightLamp.availableMaterialsList[materialRequired] then
			_thisItemCount = BrightLamp.availableMaterialsList[materialRequired]
		else
			_thisItemCount = 0
		end

		if _thisItemCount < amountNeeded then
			tooltip.description = tooltip.description .. " <RGB:1,0,0>" .. materialText .. " " .. _thisItemCount .. "/" .. amountNeeded .. " <LINE>"
			return false
		else
			tooltip.description = tooltip.description .. " <RGB:1,1,1>" .. materialText .. " " .. amountNeeded .. " <LINE>"
			return true
		end
	end

	return true
end

BrightLamp.tooltipCheckForTool = function(tool, tooltip)
	if BrightLamp.toolsList and BrightLamp.toolsList[tool] then
		tooltip.description = tooltip.description .. " <RGB:1,1,1>" .. BrightLamp.toolsText[tool] .. " <LINE>"
		return true
	else
		tooltip.description = tooltip.description .. " <RGB:1,0,0>" .. BrightLamp.toolsText[tool] .. " <LINE>"
		return false
	end
end

BrightLamp.canBuildObject = function(carpentrySkillRequired, ElectricianSkillRequired, option, player)

	local _tooltip = ISToolTip:new()
	_tooltip:initialise()
	_tooltip:setVisible(false)
	option.toolTip = _tooltip

	local _canBuildResult = true


	_tooltip.description = BrightLamp.textTooltipHeader

	local _currentResult = true

	for _, _currentMaterial in pairs(BrightLamp.neededMaterials) do
		if _currentMaterial["Material"] and _currentMaterial["Amount"] and _currentMaterial["Text"] then
			_currentResult = BrightLamp.tooltipCheckForMaterial(_currentMaterial["Material"], _currentMaterial["Amount"], _currentMaterial["Text"], _tooltip)
		else
			_tooltip.description = _tooltip.description .. " <RGB:1,0,0> Error in required material definition. <LINE>"
			_canBuildResult = false
		end

		if not _currentResult then
			_canBuildResult = false
		end
	end


	for _, _currentTool in pairs(BrightLamp.neededTools) do
		_currentResult = BrightLamp.tooltipCheckForTool(_currentTool, _tooltip)

		if not _currentResult then
			_canBuildResult = false
		end
	end


	if carpentrySkillRequired > 0 then
		if BrightLamp.playerCarpentrySkill < carpentrySkillRequired then
			_tooltip.description = _tooltip.description .. BrightLamp.textCarpentryRed
			_canBuildResult = false
		else
			_tooltip.description = _tooltip.description .. BrightLamp.textCarpentryGreen
		end

		_tooltip.description = _tooltip.description .. carpentrySkillRequired .. " <LINE>"
	end
	if ElectricianSkillRequired > 0 then
		if BrightLamp.playerelectricianSkill < ElectricianSkillRequired then
			_tooltip.description = _tooltip.description .. BrightLamp.textElectricityRed
			_canBuildResult = false
		else
			_tooltip.description = _tooltip.description .. BrightLamp.textElectricityGreen
		end

		_tooltip.description = _tooltip.description .. ElectricianSkillRequired .. " <LINE>"
	end

	if not _canBuildResult and not ISBuildMenu.cheat then
		option.onSelect = nil
		option.notAvailable = true
	end


	return _tooltip
end

local function func_Init()
	if getSteamModeActive() then
		Events.OnFillWorldObjectContextMenu.Add(BrightLamp.doBuildMenu)
	end
end

Events.OnGameStart.Add(func_Init)

BrightLamp.lightPostMenuBuilder = function(subMenu, player)
	local _sprite
	local _option
	local _tooltip
	local _name = ""

	local _brightLightPoleData = BrightLamp.getBrightLightPoleData()

	BrightLamp.neededMaterials =
	{
		{
			Material = "MetalPipe",
			Amount = 4,
			Text = getItemText("MetalPipe"),
		},

		{
			Material = "Nails",
			Amount = 8,
			Text = getItemText("Nails"),
		},

		{
			Material = "SheetMetal",
			Amount = 2,
			Text = getItemText("SheetMetal"),
		},

		{
			Material = "LightBulb",
			Amount = 2,
			Text = getItemText("LightBulb"),
		},
		{
			Material = "ElectricWire",
			Amount = 2,
			Text = getItemText("Electric Wire"),
		},
		{
			Material = "ElectronicsScrap",
			Amount = 8,
			Text = getItemText("Electronics Scrap"),
		},
	}

	BrightLamp.neededTools = { "Hammer" }

	for _, _currentList in pairs(_brightLightPoleData) do
		_sprite = {}
		_sprite.sprite = _currentList[1]

		_name = _currentList[2]

		_option = subMenu:addOption(_name, nil, BrightLamp.onBuildBrightLightPole, _sprite, player, _name)

		_tooltip = BrightLamp.canBuildObject(BrightLamp.skillLevel.lighting, BrightLamp.ElectricityskillLevel.lighting, _option, player)
		_tooltip.description = BrightLamp.textBrightLightPoleDescription .. _tooltip.description
		_tooltip:setName(_name)
		_tooltip:setTexture(_sprite.sprite)
	end
end

BrightLamp.getBrightLightPoleData = function()
	local _brightLightPoleData =
	{
		{ "lighting_outdoor_01_11", getText "ContextMenu_Bright_Light_Pole", },
		{ "lighting_outdoor_01_10", getText "ContextMenu_Bright_Light_Pole", },
		{ "lighting_outdoor_01_9", getText "ContextMenu_Bright_Light_Pole", },
		{ "lighting_outdoor_01_8", getText "ContextMenu_Bright_Light_Pole", },
	}

	return _brightLightPoleData
end

BrightLamp.onBuildBrightLightPole = function(ignoreThisArgument, sprite, player, name)
	local _brightLightPole = ISLightSource:new(sprite.sprite, sprite.sprite, getSpecificPlayer(player))

	_brightLightPole.offsetX = 5
	_brightLightPole.offsetY = 5
	_brightLightPole.player = player
	_brightLightPole.name = name

	_brightLightPole:setEastSprite(sprite.sprite)
	_brightLightPole:setSouthSprite(sprite.sprite)

	_brightLightPole.fuel = "Base.Battery"
	_brightLightPole.baseItem = "Base.LightBulb"
	_brightLightPole.radius = 20

	_brightLightPole.modData["need:Base.MetalPipe"] = "4"
	_brightLightPole.modData["need:Base.Nails"] = "8"
	_brightLightPole.modData["need:Base.SheetMetal"] = "2"
	_brightLightPole.modData["need:Base.LightBulb"] = "2"
	_brightLightPole.modData["need:Radio.ElectricWire"] = "2"
    _brightLightPole.modData["need:Base.ElectronicsScrap"] = "8"
	_brightLightPole.modData["xp:Woodwork"] = "6"
	_brightLightPole.modData["xp:Electricity"] = "6"

	getCell():setDrag(_brightLightPole, player)
end