MBlightMenu = {}

MBlightMenu.doMenu = function(player, context, worldobjects, test)
    if test and ISWorldObjectContextMenu.Test then
        return true
    end

    local thump = nil

    local square = nil

    for i, v in ipairs(worldobjects) do
        square = v:getSquare()
        if instanceof(v, 'IsoThumpable') then
            if not v:haveFuel() then
                if v:getName() == getText 'ContextMenu_Bright_Light_Pole' or v:getName() == 'Bright Light Pole' then
                    thump = v
                end
            end
        end
    end

    if test then
        return ISWorldObjectContextMenu.setTest()
    end

    if thump then
        if thump:isLightSourceOn() then
            --if test == true then return true; end
            context:addOption(getText 'ContextMenu_Turn_Off', thump, MBlightMenu.onToggleThumpableLight, player)
        elseif
            thump:getSquare():haveElectricity() or
                (SandboxVars.ElecShutModifier > -1 and
                    GameTime:getInstance():getNightsSurvived() < SandboxVars.ElecShutModifier)
         then
            --if test == true then return true; end
            context:addOption(getText 'ContextMenu_Turn_On', thump, MBlightMenu.onToggleThumpableLight, player)
        end
    end
end

MBlightMenu.onToggleThumpableLight = function(lightSource, player)
    local playerObj = getSpecificPlayer(player)
    if luautils.walkAdj(playerObj, lightSource:getSquare()) then
        ISTimedActionQueue.add(MBToggleLight:new(playerObj, lightSource, 10))
    end
end

Events.OnFillWorldObjectContextMenu.Add(MBlightMenu.doMenu)