/*
 * Decompiled with CFR 0.152.
 */
package com.crc32;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.CRC32;

public class Main {
    public static void main(String[] args) {
        try {
            String fileName84 = "84";
            File jarFile = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            String inputFilePath84 = jarFile.getParent() + File.separator + fileName84;
            String inputFilePath84_new = jarFile.getParent() + File.separator + fileName84 + "_new";
            byte[] encoded = Files.readAllBytes(Paths.get(inputFilePath84, new String[0]));
            String hex84 = Main.toHex(encoded);
            CRC32 checksum = new CRC32();
            checksum.update(encoded, 4, encoded.length - 4);
            String enc = String.format("%08X", checksum.getValue());
            StringBuffer buffer = new StringBuffer(enc);
            buffer.reverse();
            enc = Main.flip(buffer.toString());
            hex84 = enc + hex84.substring(8);
            byte[] result = Main.toByte(hex84);
            Files.write(Paths.get(inputFilePath84_new, new String[0]), result, new OpenOption[0]);
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    public static String toHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static byte[] toByte(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    static String flip(String s) {
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length - 1; i += 2) {
            char t = c[i];
            c[i] = c[i + 1];
            c[i + 1] = t;
        }
        return String.valueOf(c);
    }
}

