/*
 * Decompiled with CFR 0.152.
 */
package com.hrfix;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

public class Main {
    public static void main(String[] args) {
        try {
            int length;
            int start;
            String fileName94 = "mod";
            String fileNameQDS = "STATUS.QDS";
            File jarFile = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            String inputFilePath94 = jarFile.getParent() + File.separator + fileName94;
            String inputFilePathQDS = jarFile.getParent() + File.separator + fileNameQDS;
            byte[] bytesQDS = Files.readAllBytes(Paths.get(inputFilePathQDS, new String[0]));
            String QDShex = Main.toHex(bytesQDS);
            int begin = QDShex.indexOf(Main.StringToHex("_3801_MADJACK"), 300);
            String check = QDShex.substring(begin - 24, begin - 20);
            check = Main.unHex(check);
            String inputFilePath84 = jarFile.getParent() + File.separator + check;
            Charset charset = StandardCharsets.UTF_8;
            String content = Main.readFile(inputFilePath84, charset);
            byte[] encoded = Files.readAllBytes(Paths.get(inputFilePath84, new String[0]));
            String hex84 = Main.toHex(encoded);
            Pattern p = Pattern.compile("_\\d{4}[A-Za-z]+");
            Matcher m = p.matcher(content);
            ArrayList<String> list84hex = new ArrayList<String>();
            ArrayList<String> list84bhex = new ArrayList<String>();
            while (m.find()) {
                int start2 = m.start();
                int end = m.end();
                list84hex.add(Main.StringToHex(content.substring(start2, end)));
            }
            for (int i = 0; i < list84hex.size(); ++i) {
                if (i > 2) {
                    int shift = hex84.indexOf((String)list84hex.get(i - 1));
                    start = hex84.indexOf((String)list84hex.get(i), shift);
                    length = ((String)list84hex.get(i)).length();
                    list84bhex.add(hex84.substring(start, start + length + 2));
                    continue;
                }
                int start3 = hex84.indexOf((String)list84hex.get(i));
                int length2 = ((String)list84hex.get(i)).length();
                list84bhex.add(hex84.substring(start3, start3 + length2 + 2));
            }
            encoded = Files.readAllBytes(Paths.get(inputFilePath94, new String[0]));
            String hex94 = Main.toHex(encoded);
            for (int i = 0; i < list84hex.size(); ++i) {
                if (i > 2) {
                    int shift = hex94.indexOf((String)list84hex.get(i - 1));
                    start = hex94.indexOf((String)list84hex.get(i), shift);
                    length = ((String)list84hex.get(i)).length();
                    String replacement = hex94.substring(start, start + length + 2);
                    hex94 = hex94.replaceFirst(replacement, (String)list84bhex.get(i));
                    continue;
                }
                start = hex94.indexOf((String)list84hex.get(i));
                length = ((String)list84hex.get(i)).length();
                String replacement = hex94.substring(start, start + length + 2);
                hex94 = hex94.replaceFirst(replacement, (String)list84bhex.get(i));
            }
            byte[] result = Main.toByte(hex94);
            CRC32 checksum = new CRC32();
            checksum.update(result, 4, result.length - 4);
            String enc = String.format("%08X", checksum.getValue());
            StringBuffer buffer = new StringBuffer(enc);
            buffer.reverse();
            enc = Main.flip(buffer.toString());
            hex94 = enc + hex94.substring(8);
            result = Main.toByte(hex94);
            String inputFilePath94_new = jarFile.getParent() + File.separator + check + "_new";
            Files.write(Paths.get(inputFilePath94_new, new String[0]), result, new OpenOption[0]);
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    public static String toHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static byte[] toByte(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String StringToHex(String str) {
        char[] chars = str.toCharArray();
        StringBuffer hex = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            hex.append(Integer.toHexString(chars[i]));
        }
        return hex.toString();
    }

    static String flip(String s) {
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length - 1; i += 2) {
            char t = c[i];
            c[i] = c[i + 1];
            c[i + 1] = t;
        }
        return String.valueOf(c);
    }

    public static String unHex(String arg) {
        String str = "";
        for (int i = 0; i < arg.length(); i += 2) {
            String s = arg.substring(i, i + 2);
            int decimal = Integer.parseInt(s, 16);
            str = str + (char)decimal;
        }
        return str;
    }
}

