--[[
__scCmdLine : cmdline passed from EduLaunch
__execDir: EduLaunch's folder path
]] 
local ffi = require("ffi")
local lfs = require("lfs")
--adjust current work dir
local __current
if __execDir == nil then
    __current = lfs.currentdir()
else
    __current = __execDir
end

if string.sub(__current,-1) == "\\" then
    __current = string.sub(__current,1,-2)
end

-- add script folder to module path
local luapaths =';'..__current..'\\scripts\\?.lua;'
package.path = package.path..luapaths

require("WTypes")
local USER32 = require("user32_ffi")
local SHELL32 = require("Shell32")

local platform = '"'..__current..'\\nw.exe"'
--auto startup hprose_server
local pStartInfoServer = ffi.new("SHELLEXECUTEINFO[1]")
local hprose_server = '"'..__current..'\\hprose_server"'

pStartInfoServer[0].cbSize = ffi.sizeof("SHELLEXECUTEINFO")
pStartInfoServer[0].fMask = SHELL32.SEE_MASK_NOCLOSEPROCESS
pStartInfoServer[0].lpVerb = nil
pStartInfoServer[0].lpFile = platform
pStartInfoServer[0].lpParameters = hprose_server
pStartInfoServer[0].nShow = USER32.SW_SHOW
pStartInfoServer[0].lpDirectory = __current
pStartInfoServer[0].hInstApp = nil

SHELL32.ShellExecuteEx(pStartInfoServer)
--auto startup hotInit
local pStartInfoHot = ffi.new("SHELLEXECUTEINFO[1]")
local hotInit = '"'..__current..'\\hotInit"'

pStartInfoHot[0].cbSize = ffi.sizeof("SHELLEXECUTEINFO")
pStartInfoHot[0].fMask = SHELL32.SEE_MASK_NOCLOSEPROCESS
pStartInfoHot[0].lpVerb = nil
pStartInfoHot[0].lpFile = platform
pStartInfoHot[0].lpParameters = hotInit
pStartInfoHot[0].nShow = USER32.SW_SHOW
pStartInfoHot[0].lpDirectory = __current
pStartInfoHot[0].hInstApp = nil

SHELL32.ShellExecuteEx(pStartInfoHot)